@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Description of a NotificationHub GcmCredential.
 * @property gcmEndpoint Gets or sets the GCM endpoint.
 * @property googleApiKey Gets or sets the Google API key.
 */
public data class GcmCredentialPropertiesResponse(
    public val gcmEndpoint: String? = null,
    public val googleApiKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.GcmCredentialPropertiesResponse): GcmCredentialPropertiesResponse = GcmCredentialPropertiesResponse(
            gcmEndpoint = javaType.gcmEndpoint().map({ args0 -> args0 }).orElse(null),
            googleApiKey = javaType.googleApiKey(),
        )
    }
}
