@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents namespace properties.
 * @property createdAt Time when the namespace was created.
 * @property critical Gets or sets whether or not the namespace is set as Critical.
 * @property dataCenter Deprecated.
 * @property enabled Gets or sets whether or not the namespace is currently enabled.
 * @property metricId Azure Insights Metrics id.
 * @property name Name of the Notification Hubs namespace. This is immutable property, set automatically
 * by the service when the namespace is created.
 * @property namespaceType Defines values for NamespaceType.
 * @property networkAcls A collection of network authorization rules.
 * @property pnsCredentials Collection of Notification Hub or Notification Hub Namespace PNS credentials.
 * @property privateEndpointConnections Private Endpoint Connections for namespace
 * @property provisioningState Defines values for OperationProvisioningState.
 * @property publicNetworkAccess Type of public network access.
 * @property region Region. The value is always set to the same value as Namespace.Location, so we are deprecating
 * this property.
 * @property replicationRegion Allowed replication region
 * @property scaleUnit Gets or sets scaleUnit where the namespace gets created
 * @property serviceBusEndpoint Gets or sets endpoint you can use to perform NotificationHub
 * operations.
 * @property status Namespace status.
 * @property subscriptionId Namespace subscription id.
 * @property updatedAt Time when the namespace was updated.
 * @property zoneRedundancy Namespace SKU name.
 */
public data class NamespacePropertiesResponse(
    public val createdAt: String,
    public val critical: Boolean,
    public val dataCenter: String? = null,
    public val enabled: Boolean,
    public val metricId: String,
    public val name: String,
    public val namespaceType: String? = null,
    public val networkAcls: NetworkAclsResponse? = null,
    public val pnsCredentials: PnsCredentialsResponse? = null,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResourceResponse>,
    public val provisioningState: String? = null,
    public val publicNetworkAccess: String? = null,
    public val region: String,
    public val replicationRegion: String? = null,
    public val scaleUnit: String? = null,
    public val serviceBusEndpoint: String,
    public val status: String? = null,
    public val subscriptionId: String,
    public val updatedAt: String,
    public val zoneRedundancy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.NamespacePropertiesResponse): NamespacePropertiesResponse = NamespacePropertiesResponse(
            createdAt = javaType.createdAt(),
            critical = javaType.critical(),
            dataCenter = javaType.dataCenter().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled(),
            metricId = javaType.metricId(),
            name = javaType.name(),
            namespaceType = javaType.namespaceType().map({ args0 -> args0 }).orElse(null),
            networkAcls = javaType.networkAcls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.NetworkAclsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            pnsCredentials = javaType.pnsCredentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.PnsCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.PrivateEndpointConnectionResourceResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            region = javaType.region(),
            replicationRegion = javaType.replicationRegion().map({ args0 -> args0 }).orElse(null),
            scaleUnit = javaType.scaleUnit().map({ args0 -> args0 }).orElse(null),
            serviceBusEndpoint = javaType.serviceBusEndpoint(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId(),
            updatedAt = javaType.updatedAt(),
            zoneRedundancy = javaType.zoneRedundancy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
