@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Private Endpoint Connection properties.
 * @property groupIds List of group ids. For Notification Hubs, it always contains a single "namespace" element.
 * @property privateEndpoint Represents a Private Endpoint that is connected to Notification Hubs namespace using Private Endpoint Connection.
 * @property privateLinkServiceConnectionState State of the Private Link Service connection.
 * @property provisioningState State of Private Endpoint Connection.
 */
public data class PrivateEndpointConnectionPropertiesResponse(
    public val groupIds: List<String>,
    public val privateEndpoint: RemotePrivateEndpointConnectionResponse? = null,
    public val privateLinkServiceConnectionState: RemotePrivateLinkServiceConnectionStateResponse? =
        null,
    public val provisioningState: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.PrivateEndpointConnectionPropertiesResponse): PrivateEndpointConnectionPropertiesResponse = PrivateEndpointConnectionPropertiesResponse(
            groupIds = javaType.groupIds().map({ args0 -> args0 }),
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.RemotePrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.notificationhubs.kotlin.outputs.RemotePrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
        )
    }
}
