@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A default (public Internet) network authorization rule, which contains rights if no other network rule matches.
 * @property rights List of access rights.
 */
public data class PublicInternetAuthorizationRuleResponse(
    public val rights: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.PublicInternetAuthorizationRuleResponse): PublicInternetAuthorizationRuleResponse = PublicInternetAuthorizationRuleResponse(
            rights = javaType.rights().map({ args0 -> args0 }),
        )
    }
}
