@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a Private Endpoint that is connected to Notification Hubs namespace using Private Endpoint Connection.
 * @property id ARM resource ID of the Private Endpoint. This may belong to different subscription and resource group than a Notification Hubs namespace.
 */
public data class RemotePrivateEndpointConnectionResponse(
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.RemotePrivateEndpointConnectionResponse): RemotePrivateEndpointConnectionResponse = RemotePrivateEndpointConnectionResponse(
            id = javaType.id(),
        )
    }
}
