@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * State of the Private Link Service connection.
 * @property actionsRequired Human-friendly description of required actions.
 * @property description Human-friendly description.
 * @property status State of Private Link Connection.
 */
public data class RemotePrivateLinkServiceConnectionStateResponse(
    public val actionsRequired: String,
    public val description: String,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.RemotePrivateLinkServiceConnectionStateResponse): RemotePrivateLinkServiceConnectionStateResponse =
            RemotePrivateLinkServiceConnectionStateResponse(
                actionsRequired = javaType.actionsRequired(),
                description = javaType.description(),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
