@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Description of a NotificationHub WnsCredential.
 * @property certificateKey Ges or sets the WNS Certificate Key.
 * @property packageSid Gets or sets the package ID for this credential.
 * @property secretKey Gets or sets the secret key.
 * @property windowsLiveEndpoint Gets or sets the Windows Live endpoint.
 * @property wnsCertificate Gets or sets the WNS Certificate.
 */
public data class WnsCredentialPropertiesResponse(
    public val certificateKey: String? = null,
    public val packageSid: String? = null,
    public val secretKey: String? = null,
    public val windowsLiveEndpoint: String? = null,
    public val wnsCertificate: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.WnsCredentialPropertiesResponse): WnsCredentialPropertiesResponse = WnsCredentialPropertiesResponse(
            certificateKey = javaType.certificateKey().map({ args0 -> args0 }).orElse(null),
            packageSid = javaType.packageSid().map({ args0 -> args0 }).orElse(null),
            secretKey = javaType.secretKey().map({ args0 -> args0 }).orElse(null),
            windowsLiveEndpoint = javaType.windowsLiveEndpoint().map({ args0 -> args0 }).orElse(null),
            wnsCertificate = javaType.wnsCertificate().map({ args0 -> args0 }).orElse(null),
        )
    }
}
