@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Description of a NotificationHub XiaomiCredentialProperties.
 * @property appSecret Gets or sets app secret.
 * @property endpoint Gets or sets xiaomi service endpoint.
 */
public data class XiaomiCredentialPropertiesResponse(
    public val appSecret: String? = null,
    public val endpoint: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.XiaomiCredentialPropertiesResponse): XiaomiCredentialPropertiesResponse = XiaomiCredentialPropertiesResponse(
            appSecret = javaType.appSecret().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint().map({ args0 -> args0 }).orElse(null),
        )
    }
}
