@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.HypervHostControllerArgs.builder
import com.pulumi.azurenative.offazure.kotlin.enums.ProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A host resource belonging to a site resource.
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### HypervHostController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hypervHostController = new AzureNative.OffAzure.HypervHostController("hypervHostController", new()
 *     {
 *         Fqdn = "okkwk",
 *         HostName = "XQ-753h-765DG2",
 *         ProvisioningState = AzureNative.OffAzure.ProvisioningState.Created,
 *         ResourceGroupName = "rgmigrate",
 *         RunAsAccountId = "pjgyebznvfxnjzjqt",
 *         SiteName = "---7ed-q11Nx46-98",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewHypervHostController(ctx, "hypervHostController", &offazure.HypervHostControllerArgs{
 * 			Fqdn:              pulumi.String("okkwk"),
 * 			HostName:          pulumi.String("XQ-753h-765DG2"),
 * 			ProvisioningState: pulumi.String(offazure.ProvisioningStateCreated),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			RunAsAccountId:    pulumi.String("pjgyebznvfxnjzjqt"),
 * 			SiteName:          pulumi.String("---7ed-q11Nx46-98"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.HypervHostController;
 * import com.pulumi.azurenative.offazure.HypervHostControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hypervHostController = new HypervHostController("hypervHostController", HypervHostControllerArgs.builder()
 *             .fqdn("okkwk")
 *             .hostName("XQ-753h-765DG2")
 *             .provisioningState("Created")
 *             .resourceGroupName("rgmigrate")
 *             .runAsAccountId("pjgyebznvfxnjzjqt")
 *             .siteName("---7ed-q11Nx46-98")
 *             .build());
 *     }
 * }
 * ```
 * ### HypervHostController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hypervHostController = new AzureNative.OffAzure.HypervHostController("hypervHostController", new()
 *     {
 *         HostName = "IIfm6suXoKL",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "-25mH3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewHypervHostController(ctx, "hypervHostController", &offazure.HypervHostControllerArgs{
 * 			HostName:          pulumi.String("IIfm6suXoKL"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("-25mH3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.HypervHostController;
 * import com.pulumi.azurenative.offazure.HypervHostControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hypervHostController = new HypervHostController("hypervHostController", HypervHostControllerArgs.builder()
 *             .hostName("IIfm6suXoKL")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("-25mH3")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:HypervHostController kgosttkbfbrsge /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/hypervSites/{siteName}/hosts/{hostName}
 * ```
 * @property fqdn Gets or sets the FQDN/IPAddress of the Hyper-V host.
 * @property hostName  Host name
 * @property provisioningState The status of the last operation.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property runAsAccountId Gets or sets the run as account ID of the Hyper-V host.
 * @property siteName Site name
 */
public data class HypervHostControllerArgs(
    public val fqdn: Output<String>? = null,
    public val hostName: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val runAsAccountId: Output<String>? = null,
    public val siteName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.HypervHostControllerArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.HypervHostControllerArgs =
        com.pulumi.azurenative.offazure.HypervHostControllerArgs.builder()
            .fqdn(fqdn?.applyValue({ args0 -> args0 }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .runAsAccountId(runAsAccountId?.applyValue({ args0 -> args0 }))
            .siteName(siteName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HypervHostControllerArgs].
 */
@PulumiTagMarker
public class HypervHostControllerArgsBuilder internal constructor() {
    private var fqdn: Output<String>? = null

    private var hostName: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var resourceGroupName: Output<String>? = null

    private var runAsAccountId: Output<String>? = null

    private var siteName: Output<String>? = null

    /**
     * @param value Gets or sets the FQDN/IPAddress of the Hyper-V host.
     */
    @JvmName("pchjywackptlroyx")
    public suspend fun fqdn(`value`: Output<String>) {
        this.fqdn = value
    }

    /**
     * @param value  Host name
     */
    @JvmName("xfsyotybpihdiroc")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("horhkisqbbxaukyp")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aqoiajblsjurqmbv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the run as account ID of the Hyper-V host.
     */
    @JvmName("mnqcqwsikddjgknt")
    public suspend fun runAsAccountId(`value`: Output<String>) {
        this.runAsAccountId = value
    }

    /**
     * @param value Site name
     */
    @JvmName("tbutoyhtqmewrfcu")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value Gets or sets the FQDN/IPAddress of the Hyper-V host.
     */
    @JvmName("imbkadrwencsxvlh")
    public suspend fun fqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdn = mapped
    }

    /**
     * @param value  Host name
     */
    @JvmName("ctidfsxtwwlivtii")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("yncaqhnntagcahkd")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("kkfcbfklxpihiwnl")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("fqgnbgqivvnciqkx")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sfkmwseyyyfoxfsp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the run as account ID of the Hyper-V host.
     */
    @JvmName("ywunegnfijrgxfbw")
    public suspend fun runAsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsAccountId = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("occxwdjpuksmhpmo")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    internal fun build(): HypervHostControllerArgs = HypervHostControllerArgs(
        fqdn = fqdn,
        hostName = hostName,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        runAsAccountId = runAsAccountId,
        siteName = siteName,
    )
}
