@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.kotlin.outputs.SiteAgentPropertiesResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.SiteSpnPropertiesResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.offazure.kotlin.outputs.SiteAgentPropertiesResponse.Companion.toKotlin as siteAgentPropertiesResponseToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.SiteSpnPropertiesResponse.Companion.toKotlin as siteSpnPropertiesResponseToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [HypervSitesController].
 */
@PulumiTagMarker
public class HypervSitesControllerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HypervSitesControllerArgs = HypervSitesControllerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HypervSitesControllerArgsBuilder.() -> Unit) {
        val builder = HypervSitesControllerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HypervSitesController {
        val builtJavaResource =
            com.pulumi.azurenative.offazure.HypervSitesController(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HypervSitesController(builtJavaResource)
    }
}

/**
 * A HyperV SiteResource
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### HypervSitesController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hypervSitesController = new AzureNative.OffAzure.HypervSitesController("hypervSitesController", new()
 *     {
 *         AgentDetails = new AzureNative.OffAzure.Inputs.SiteAgentPropertiesArgs
 *         {
 *             KeyVaultId = "awxurtbjmofxuciewsqfgpkccpzw",
 *             KeyVaultUri = "qizphgqwage",
 *         },
 *         ApplianceName = "jnpsjguxuzuxbhasiqfijf",
 *         DiscoverySolutionId = "yxajidsykozchjkuxj",
 *         Location = "sctymxdndonxgejdhi",
 *         ProvisioningState = AzureNative.OffAzure.ProvisioningState.Created,
 *         ResourceGroupName = "rgmigrate",
 *         ServicePrincipalIdentityDetails = new AzureNative.OffAzure.Inputs.SiteSpnPropertiesArgs
 *         {
 *             AadAuthority = "yanzipdww",
 *             ApplicationId = "tspgrujepxyxuprkqvfuqbbjrweeqa",
 *             Audience = "oepwfaozztzvegmzvswafvotj",
 *             ObjectId = "tqrjngpgxnnto",
 *             RawCertData = "dotvgkslkmsgvtekgojnhcdrryk",
 *             TenantId = "vesmyhu",
 *         },
 *         SiteName = "692-u-93F93",
 *         Tags =
 *         {
 *             { "key9741", "fdbzykkpvhnhsrhiam" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewHypervSitesController(ctx, "hypervSitesController", &offazure.HypervSitesControllerArgs{
 * 			AgentDetails: &offazure.SiteAgentPropertiesArgs{
 * 				KeyVaultId:  pulumi.String("awxurtbjmofxuciewsqfgpkccpzw"),
 * 				KeyVaultUri: pulumi.String("qizphgqwage"),
 * 			},
 * 			ApplianceName:       pulumi.String("jnpsjguxuzuxbhasiqfijf"),
 * 			DiscoverySolutionId: pulumi.String("yxajidsykozchjkuxj"),
 * 			Location:            pulumi.String("sctymxdndonxgejdhi"),
 * 			ProvisioningState:   pulumi.String(offazure.ProvisioningStateCreated),
 * 			ResourceGroupName:   pulumi.String("rgmigrate"),
 * 			ServicePrincipalIdentityDetails: &offazure.SiteSpnPropertiesArgs{
 * 				AadAuthority:  pulumi.String("yanzipdww"),
 * 				ApplicationId: pulumi.String("tspgrujepxyxuprkqvfuqbbjrweeqa"),
 * 				Audience:      pulumi.String("oepwfaozztzvegmzvswafvotj"),
 * 				ObjectId:      pulumi.String("tqrjngpgxnnto"),
 * 				RawCertData:   pulumi.String("dotvgkslkmsgvtekgojnhcdrryk"),
 * 				TenantId:      pulumi.String("vesmyhu"),
 * 			},
 * 			SiteName: pulumi.String("692-u-93F93"),
 * 			Tags: pulumi.StringMap{
 * 				"key9741": pulumi.String("fdbzykkpvhnhsrhiam"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.HypervSitesController;
 * import com.pulumi.azurenative.offazure.HypervSitesControllerArgs;
 * import com.pulumi.azurenative.offazure.inputs.SiteAgentPropertiesArgs;
 * import com.pulumi.azurenative.offazure.inputs.SiteSpnPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hypervSitesController = new HypervSitesController("hypervSitesController", HypervSitesControllerArgs.builder()
 *             .agentDetails(SiteAgentPropertiesArgs.builder()
 *                 .keyVaultId("awxurtbjmofxuciewsqfgpkccpzw")
 *                 .keyVaultUri("qizphgqwage")
 *                 .build())
 *             .applianceName("jnpsjguxuzuxbhasiqfijf")
 *             .discoverySolutionId("yxajidsykozchjkuxj")
 *             .location("sctymxdndonxgejdhi")
 *             .provisioningState("Created")
 *             .resourceGroupName("rgmigrate")
 *             .servicePrincipalIdentityDetails(SiteSpnPropertiesArgs.builder()
 *                 .aadAuthority("yanzipdww")
 *                 .applicationId("tspgrujepxyxuprkqvfuqbbjrweeqa")
 *                 .audience("oepwfaozztzvegmzvswafvotj")
 *                 .objectId("tqrjngpgxnnto")
 *                 .rawCertData("dotvgkslkmsgvtekgojnhcdrryk")
 *                 .tenantId("vesmyhu")
 *                 .build())
 *             .siteName("692-u-93F93")
 *             .tags(Map.of("key9741", "fdbzykkpvhnhsrhiam"))
 *             .build());
 *     }
 * }
 * ```
 * ### HypervSitesController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hypervSitesController = new AzureNative.OffAzure.HypervSitesController("hypervSitesController", new()
 *     {
 *         Location = "sctymxdndonxgejdhi",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "Y-C-7---V49GV-058XE-6P5",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewHypervSitesController(ctx, "hypervSitesController", &offazure.HypervSitesControllerArgs{
 * 			Location:          pulumi.String("sctymxdndonxgejdhi"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("Y-C-7---V49GV-058XE-6P5"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.HypervSitesController;
 * import com.pulumi.azurenative.offazure.HypervSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hypervSitesController = new HypervSitesController("hypervSitesController", HypervSitesControllerArgs.builder()
 *             .location("sctymxdndonxgejdhi")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("Y-C-7---V49GV-058XE-6P5")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:HypervSitesController xnxtdkrodsftjeebdwdkgpneqtzf /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/hypervSites/{siteName}
 * ```
 */
public class HypervSitesController internal constructor(
    override val javaResource: com.pulumi.azurenative.offazure.HypervSitesController,
) : KotlinCustomResource(javaResource, HypervSitesControllerMapper) {
    /**
     * Gets or sets the on-premises agent details.
     */
    public val agentDetails: Output<SiteAgentPropertiesResponse>?
        get() = javaResource.agentDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    siteAgentPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets the Appliance Name.
     */
    public val applianceName: Output<String>?
        get() = javaResource.applianceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the ARM ID of migration hub solution for SDS.
     */
    public val discoverySolutionId: Output<String>?
        get() = javaResource.discoverySolutionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Gets the Master Site this site is linked to.
     */
    public val masterSiteId: Output<String>
        get() = javaResource.masterSiteId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the service endpoint.
     */
    public val serviceEndpoint: Output<String>
        get() = javaResource.serviceEndpoint().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the service principal identity details used by agent for
     * communication
     *             to the service.
     */
    public val servicePrincipalIdentityDetails: Output<SiteSpnPropertiesResponse>?
        get() = javaResource.servicePrincipalIdentityDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> siteSpnPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object HypervSitesControllerMapper : ResourceMapper<HypervSitesController> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.offazure.HypervSitesController::class == javaResource::class

    override fun map(javaResource: Resource): HypervSitesController =
        HypervSitesController(javaResource as com.pulumi.azurenative.offazure.HypervSitesController)
}

/**
 * @see [HypervSitesController].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HypervSitesController].
 */
public suspend fun hypervSitesController(
    name: String,
    block: suspend HypervSitesControllerResourceBuilder.() -> Unit,
): HypervSitesController {
    val builder = HypervSitesControllerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HypervSitesController].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hypervSitesController(name: String): HypervSitesController {
    val builder = HypervSitesControllerResourceBuilder()
    builder.name(name)
    return builder.build()
}
