@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.kotlin.outputs.SitePropertiesResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.offazure.kotlin.outputs.SitePropertiesResponse.Companion.toKotlin as sitePropertiesResponseToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Site].
 */
@PulumiTagMarker
public class SiteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SiteArgs = SiteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SiteArgsBuilder.() -> Unit) {
        val builder = SiteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Site {
        val builtJavaResource = com.pulumi.azurenative.offazure.Site(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Site(builtJavaResource)
    }
}

/**
 * Site REST Resource.
 * Azure REST API version: 2020-07-07. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Create VMware site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var site = new AzureNative.OffAzure.Site("site", new()
 *     {
 *         Location = "eastus",
 *         Properties = new AzureNative.OffAzure.Inputs.SitePropertiesArgs
 *         {
 *             ServicePrincipalIdentityDetails = new AzureNative.OffAzure.Inputs.SiteSpnPropertiesArgs
 *             {
 *                 AadAuthority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 ApplicationId = "e9f013df-2a2a-4871-b766-e79867f30348",
 *                 Audience = "https://72f988bf-86f1-41af-91ab-2d7cd011db47/MaheshSite17ac9agentauthaadapp",
 *                 ObjectId = "2cd492bc-7ef3-4ee0-b301-59a88108b47b",
 *                 TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *             },
 *         },
 *         ResourceGroupName = "pajindTest",
 *         SiteName = "appliance1e39site",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewSite(ctx, "site", &offazure.SiteArgs{
 * 			Location: pulumi.String("eastus"),
 * 			Properties: &offazure.SitePropertiesArgs{
 * 				ServicePrincipalIdentityDetails: &offazure.SiteSpnPropertiesArgs{
 * 					AadAuthority:  pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					ApplicationId: pulumi.String("e9f013df-2a2a-4871-b766-e79867f30348"),
 * 					Audience:      pulumi.String("https://72f988bf-86f1-41af-91ab-2d7cd011db47/MaheshSite17ac9agentauthaadapp"),
 * 					ObjectId:      pulumi.String("2cd492bc-7ef3-4ee0-b301-59a88108b47b"),
 * 					TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("pajindTest"),
 * 			SiteName:          pulumi.String("appliance1e39site"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.Site;
 * import com.pulumi.azurenative.offazure.SiteArgs;
 * import com.pulumi.azurenative.offazure.inputs.SitePropertiesArgs;
 * import com.pulumi.azurenative.offazure.inputs.SiteSpnPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var site = new Site("site", SiteArgs.builder()
 *             .location("eastus")
 *             .properties(SitePropertiesArgs.builder()
 *                 .servicePrincipalIdentityDetails(SiteSpnPropertiesArgs.builder()
 *                     .aadAuthority("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                     .applicationId("e9f013df-2a2a-4871-b766-e79867f30348")
 *                     .audience("https://72f988bf-86f1-41af-91ab-2d7cd011db47/MaheshSite17ac9agentauthaadapp")
 *                     .objectId("2cd492bc-7ef3-4ee0-b301-59a88108b47b")
 *                     .tenantId("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("pajindTest")
 *             .siteName("appliance1e39site")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:Site appliance1e39site /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/VMwareSites/{siteName}
 * ```
 */
public class Site internal constructor(
    override val javaResource: com.pulumi.azurenative.offazure.Site,
) : KotlinCustomResource(javaResource, SiteMapper) {
    /**
     * eTag for concurrency control.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure location in which Sites is created.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the VMware site.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Nested properties of VMWare site.
     */
    public val properties: Output<SitePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                sitePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Type of resource. Type = Microsoft.OffAzure/VMWareSites.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SiteMapper : ResourceMapper<Site> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.offazure.Site::class == javaResource::class

    override fun map(javaResource: Resource): Site = Site(
        javaResource as
            com.pulumi.azurenative.offazure.Site,
    )
}

/**
 * @see [Site].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Site].
 */
public suspend fun site(name: String, block: suspend SiteResourceBuilder.() -> Unit): Site {
    val builder = SiteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Site].
 * @param name The _unique_ name of the resulting resource.
 */
public fun site(name: String): Site {
    val builder = SiteResourceBuilder()
    builder.name(name)
    return builder.build()
}
