@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.kotlin.outputs.SiteAppliancePropertiesResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.offazure.kotlin.outputs.SiteAppliancePropertiesResponse.Companion.toKotlin as siteAppliancePropertiesResponseToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [WebAppSitesController].
 */
@PulumiTagMarker
public class WebAppSitesControllerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppSitesControllerArgs = WebAppSitesControllerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAppSitesControllerArgsBuilder.() -> Unit) {
        val builder = WebAppSitesControllerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAppSitesController {
        val builtJavaResource =
            com.pulumi.azurenative.offazure.WebAppSitesController(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppSitesController(builtJavaResource)
    }
}

/**
 * WebApp site web model.
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### WebAppSitesController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppSitesController = new AzureNative.OffAzure.WebAppSitesController("webAppSitesController", new()
 *     {
 *         DiscoveryScenario = AzureNative.OffAzure.WebAppSitePropertiesDiscoveryScenario.Migrate,
 *         ResourceGroupName = "rgmigrate",
 *         SiteAppliancePropertiesCollection = new[]
 *         {
 *             new AzureNative.OffAzure.Inputs.SiteAppliancePropertiesArgs
 *             {
 *                 AgentDetails = new AzureNative.OffAzure.Inputs.SiteAgentPropertiesArgs
 *                 {
 *                     KeyVaultId = "awxurtbjmofxuciewsqfgpkccpzw",
 *                     KeyVaultUri = "qizphgqwage",
 *                 },
 *                 ApplianceName = "zpbkpigahvexsxevwafzgsu",
 *                 ServicePrincipalIdentityDetails = new AzureNative.OffAzure.Inputs.SiteSpnPropertiesArgs
 *                 {
 *                     AadAuthority = "yanzipdww",
 *                     ApplicationId = "tspgrujepxyxuprkqvfuqbbjrweeqa",
 *                     Audience = "oepwfaozztzvegmzvswafvotj",
 *                     ObjectId = "tqrjngpgxnnto",
 *                     RawCertData = "dotvgkslkmsgvtekgojnhcdrryk",
 *                     TenantId = "vesmyhu",
 *                 },
 *             },
 *         },
 *         SiteName = "36cmQ",
 *         WebAppSiteName = "GJRq",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewWebAppSitesController(ctx, "webAppSitesController", &offazure.WebAppSitesControllerArgs{
 * 			DiscoveryScenario: pulumi.String(offazure.WebAppSitePropertiesDiscoveryScenarioMigrate),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteAppliancePropertiesCollection: offazure.SiteAppliancePropertiesArray{
 * 				&offazure.SiteAppliancePropertiesArgs{
 * 					AgentDetails: &offazure.SiteAgentPropertiesArgs{
 * 						KeyVaultId:  pulumi.String("awxurtbjmofxuciewsqfgpkccpzw"),
 * 						KeyVaultUri: pulumi.String("qizphgqwage"),
 * 					},
 * 					ApplianceName: pulumi.String("zpbkpigahvexsxevwafzgsu"),
 * 					ServicePrincipalIdentityDetails: &offazure.SiteSpnPropertiesArgs{
 * 						AadAuthority:  pulumi.String("yanzipdww"),
 * 						ApplicationId: pulumi.String("tspgrujepxyxuprkqvfuqbbjrweeqa"),
 * 						Audience:      pulumi.String("oepwfaozztzvegmzvswafvotj"),
 * 						ObjectId:      pulumi.String("tqrjngpgxnnto"),
 * 						RawCertData:   pulumi.String("dotvgkslkmsgvtekgojnhcdrryk"),
 * 						TenantId:      pulumi.String("vesmyhu"),
 * 					},
 * 				},
 * 			},
 * 			SiteName:       pulumi.String("36cmQ"),
 * 			WebAppSiteName: pulumi.String("GJRq"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.WebAppSitesController;
 * import com.pulumi.azurenative.offazure.WebAppSitesControllerArgs;
 * import com.pulumi.azurenative.offazure.inputs.SiteAppliancePropertiesArgs;
 * import com.pulumi.azurenative.offazure.inputs.SiteAgentPropertiesArgs;
 * import com.pulumi.azurenative.offazure.inputs.SiteSpnPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppSitesController = new WebAppSitesController("webAppSitesController", WebAppSitesControllerArgs.builder()
 *             .discoveryScenario("Migrate")
 *             .resourceGroupName("rgmigrate")
 *             .siteAppliancePropertiesCollection(SiteAppliancePropertiesArgs.builder()
 *                 .agentDetails(SiteAgentPropertiesArgs.builder()
 *                     .keyVaultId("awxurtbjmofxuciewsqfgpkccpzw")
 *                     .keyVaultUri("qizphgqwage")
 *                     .build())
 *                 .applianceName("zpbkpigahvexsxevwafzgsu")
 *                 .servicePrincipalIdentityDetails(SiteSpnPropertiesArgs.builder()
 *                     .aadAuthority("yanzipdww")
 *                     .applicationId("tspgrujepxyxuprkqvfuqbbjrweeqa")
 *                     .audience("oepwfaozztzvegmzvswafvotj")
 *                     .objectId("tqrjngpgxnnto")
 *                     .rawCertData("dotvgkslkmsgvtekgojnhcdrryk")
 *                     .tenantId("vesmyhu")
 *                     .build())
 *                 .build())
 *             .siteName("36cmQ")
 *             .webAppSiteName("GJRq")
 *             .build());
 *     }
 * }
 * ```
 * ### WebAppSitesController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppSitesController = new AzureNative.OffAzure.WebAppSitesController("webAppSitesController", new()
 *     {
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "s13669b---4sI",
 *         WebAppSiteName = "3BXk-O8O6W3-GB7J",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewWebAppSitesController(ctx, "webAppSitesController", &offazure.WebAppSitesControllerArgs{
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("s13669b---4sI"),
 * 			WebAppSiteName:    pulumi.String("3BXk-O8O6W3-GB7J"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.WebAppSitesController;
 * import com.pulumi.azurenative.offazure.WebAppSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppSitesController = new WebAppSitesController("webAppSitesController", WebAppSitesControllerArgs.builder()
 *             .resourceGroupName("rgmigrate")
 *             .siteName("s13669b---4sI")
 *             .webAppSiteName("3BXk-O8O6W3-GB7J")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:WebAppSitesController tyyjy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/masterSites/{siteName}/webAppSites/{webAppSiteName}
 * ```
 */
public class WebAppSitesController internal constructor(
    override val javaResource: com.pulumi.azurenative.offazure.WebAppSitesController,
) : KotlinCustomResource(javaResource, WebAppSitesControllerMapper) {
    /**
     * Gets or sets the discovery scenario.
     */
    public val discoveryScenario: Output<String>?
        get() = javaResource.discoveryScenario().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * provisioning state enum
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets the service endpoint.
     */
    public val serviceEndpoint: Output<String>
        get() = javaResource.serviceEndpoint().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the appliance details used by service to communicate
     * to the appliance.
     */
    public val siteAppliancePropertiesCollection: Output<List<SiteAppliancePropertiesResponse>>?
        get() = javaResource.siteAppliancePropertiesCollection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        siteAppliancePropertiesResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppSitesControllerMapper : ResourceMapper<WebAppSitesController> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.offazure.WebAppSitesController::class == javaResource::class

    override fun map(javaResource: Resource): WebAppSitesController =
        WebAppSitesController(javaResource as com.pulumi.azurenative.offazure.WebAppSitesController)
}

/**
 * @see [WebAppSitesController].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppSitesController].
 */
public suspend fun webAppSitesController(
    name: String,
    block: suspend WebAppSitesControllerResourceBuilder.() -> Unit,
): WebAppSitesController {
    val builder = WebAppSitesControllerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppSitesController].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppSitesController(name: String): WebAppSitesController {
    val builder = WebAppSitesControllerResourceBuilder()
    builder.name(name)
    return builder.build()
}
