@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.inputs

import com.pulumi.azurenative.offazure.inputs.GetHypervClusterControllerClusterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName  Cluster ARM name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName Site name
 */
public data class GetHypervClusterControllerClusterPlainArgs(
    public val clusterName: String,
    public val resourceGroupName: String,
    public val siteName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.offazure.inputs.GetHypervClusterControllerClusterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.inputs.GetHypervClusterControllerClusterPlainArgs =
        com.pulumi.azurenative.offazure.inputs.GetHypervClusterControllerClusterPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .siteName(siteName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHypervClusterControllerClusterPlainArgs].
 */
@PulumiTagMarker
public class GetHypervClusterControllerClusterPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    private var siteName: String? = null

    /**
     * @param value  Cluster ARM name
     */
    @JvmName("vnphetbsbejpsrox")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jcmaycidensnbhsk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("qsphvdevvcovmgye")
    public suspend fun siteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.siteName = mapped
    }

    internal fun build(): GetHypervClusterControllerClusterPlainArgs =
        GetHypervClusterControllerClusterPlainArgs(
            clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            siteName = siteName ?: throw PulumiNullFieldException("siteName"),
        )
}
