@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.inputs

import com.pulumi.azurenative.offazure.inputs.PrivateLinkServiceConnectionStateArgs.builder
import com.pulumi.azurenative.offazure.kotlin.enums.PrivateLinkServiceConnectionStateStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Service Connection State
 * @property actionsRequired actions required
 * @property description description string
 * @property status state status
 */
public data class PrivateLinkServiceConnectionStateArgs(
    public val actionsRequired: Output<String>? = null,
    public val description: Output<String>? = null,
    public val status: Output<Either<String, PrivateLinkServiceConnectionStateStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.inputs.PrivateLinkServiceConnectionStateArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.inputs.PrivateLinkServiceConnectionStateArgs =
        com.pulumi.azurenative.offazure.inputs.PrivateLinkServiceConnectionStateArgs.builder()
            .actionsRequired(actionsRequired?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkServiceConnectionStateArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceConnectionStateArgsBuilder internal constructor() {
    private var actionsRequired: Output<String>? = null

    private var description: Output<String>? = null

    private var status: Output<Either<String, PrivateLinkServiceConnectionStateStatus>>? = null

    /**
     * @param value actions required
     */
    @JvmName("ovfdhgaqftflwvmq")
    public suspend fun actionsRequired(`value`: Output<String>) {
        this.actionsRequired = value
    }

    /**
     * @param value description string
     */
    @JvmName("lkxmwwxrndfmkkss")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value state status
     */
    @JvmName("mxgfypgfseixfexs")
    public suspend fun status(`value`: Output<Either<String, PrivateLinkServiceConnectionStateStatus>>) {
        this.status = value
    }

    /**
     * @param value actions required
     */
    @JvmName("uflkxsgukxpjjayu")
    public suspend fun actionsRequired(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionsRequired = mapped
    }

    /**
     * @param value description string
     */
    @JvmName("rrmtnlnnpfaofwyx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value state status
     */
    @JvmName("uaiohbjdwnthqoje")
    public suspend fun status(`value`: Either<String, PrivateLinkServiceConnectionStateStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value state status
     */
    @JvmName("wjcivedemxqmbkrx")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateLinkServiceConnectionStateStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value state status
     */
    @JvmName("piqbbxiewisxtagu")
    public fun status(`value`: PrivateLinkServiceConnectionStateStatus) {
        val toBeMapped = Either.ofRight<String, PrivateLinkServiceConnectionStateStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PrivateLinkServiceConnectionStateArgs =
        PrivateLinkServiceConnectionStateArgs(
            actionsRequired = actionsRequired,
            description = description,
            status = status,
        )
}
