@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Site REST Resource.
 * @property eTag eTag for concurrency control.
 * @property id Resource Id.
 * @property location Azure location in which Sites is created.
 * @property name Name of the Hyper-V site.
 * @property properties Nested properties of Hyper-V site.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags
 * @property type Type of resource. Type = Microsoft.OffAzure/HyperVSites.
 */
public data class GetHyperVSiteResult(
    public val eTag: String? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String? = null,
    public val properties: SitePropertiesResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.offazure.outputs.GetHyperVSiteResult): GetHyperVSiteResult = GetHyperVSiteResult(
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.offazure.kotlin.outputs.SitePropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
