@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A ImportSite
 * @property discoverySolutionId Gets or sets the ARM ID of migration hub solution for SDS.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property masterSiteId Gets the Master Site this site is linked to.
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property serviceEndpoint Gets the service endpoint.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetImportSitesControllerResult(
    public val discoverySolutionId: String? = null,
    public val id: String,
    public val location: String,
    public val masterSiteId: String,
    public val name: String,
    public val provisioningState: String? = null,
    public val serviceEndpoint: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.offazure.outputs.GetImportSitesControllerResult): GetImportSitesControllerResult = GetImportSitesControllerResult(
            discoverySolutionId = javaType.discoverySolutionId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            masterSiteId = javaType.masterSiteId(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            serviceEndpoint = javaType.serviceEndpoint(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
