@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A ServerSiteResource
 * @property agentDetails Gets or sets the on-premises agent details.
 * @property applianceName Gets or sets the Appliance Name.
 * @property discoverySolutionId Gets or sets the ARM ID of migration hub solution for SDS.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property masterSiteId Gets the Master Site this site is linked to.
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property serviceEndpoint Gets the service endpoint.
 * @property servicePrincipalIdentityDetails Gets or sets the service principal identity details used by agent for
 * communication
 *             to the service.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetServerSitesControllerResult(
    public val agentDetails: SiteAgentPropertiesResponse? = null,
    public val applianceName: String? = null,
    public val discoverySolutionId: String? = null,
    public val id: String,
    public val location: String,
    public val masterSiteId: String,
    public val name: String,
    public val provisioningState: String,
    public val serviceEndpoint: String,
    public val servicePrincipalIdentityDetails: SiteSpnPropertiesResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.offazure.outputs.GetServerSitesControllerResult): GetServerSitesControllerResult = GetServerSitesControllerResult(
            agentDetails = javaType.agentDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.offazure.kotlin.outputs.SiteAgentPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            applianceName = javaType.applianceName().map({ args0 -> args0 }).orElse(null),
            discoverySolutionId = javaType.discoverySolutionId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            masterSiteId = javaType.masterSiteId(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            serviceEndpoint = javaType.serviceEndpoint(),
            servicePrincipalIdentityDetails = javaType.servicePrincipalIdentityDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.offazure.kotlin.outputs.SiteSpnPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
