@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A vcenter resource belonging to a site resource.
 * @property createdTimestamp Gets the timestamp marking vCenter creation.
 * @property errors Gets the errors.
 * @property fqdn Gets or sets the FQDN/IPAddress of the vCenter.
 * @property friendlyName Gets or sets the friendly name of the vCenter.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property instanceUuid Gets the instance UUID of the vCenter.
 * @property name The name of the resource
 * @property perfStatisticsLevel Gets the performance statistics enabled on the vCenter.
 * @property port Gets or sets the port of the vCenter.
 * @property provisioningState The status of the last operation.
 * @property runAsAccountId Gets or sets the run as account ID of the vCenter.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property updatedTimestamp Gets the timestamp marking last updated on the vCenter.
 * @property version Gets the version of the vCenter.
 */
public data class GetVcenterControllerResult(
    public val createdTimestamp: String,
    public val errors: List<HealthErrorDetailsResponse>,
    public val fqdn: String? = null,
    public val friendlyName: String? = null,
    public val id: String,
    public val instanceUuid: String,
    public val name: String,
    public val perfStatisticsLevel: String,
    public val port: String? = null,
    public val provisioningState: String? = null,
    public val runAsAccountId: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val updatedTimestamp: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.offazure.outputs.GetVcenterControllerResult): GetVcenterControllerResult = GetVcenterControllerResult(
            createdTimestamp = javaType.createdTimestamp(),
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.offazure.kotlin.outputs.HealthErrorDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            fqdn = javaType.fqdn().map({ args0 -> args0 }).orElse(null),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            instanceUuid = javaType.instanceUuid(),
            name = javaType.name(),
            perfStatisticsLevel = javaType.perfStatisticsLevel(),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            runAsAccountId = javaType.runAsAccountId().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            updatedTimestamp = javaType.updatedTimestamp(),
            version = javaType.version(),
        )
    }
}
