@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Error contract returned when some exception occurs in Rest API.
 * @property applianceName Gets the appliance name.
 * @property code Gets the error name.
 * @property discoveryScope Gets discovery scope for which             error is encountered.
 * @property id Gets the error ID.
 * @property message Gets the error message.
 * @property messageParameters Gets the message parameters.
 * @property possibleCauses Gets the possible causes of error.
 * @property recommendedAction Gets the recommended action to resolve error.
 * @property runAsAccountId Gets run as account id used while performing discovery             of entity.
 * @property severity Gets the error severity.
 * @property source Gets the error source.
 * @property summaryMessage Gets the error summary message.
 * @property updatedTimeStamp Gets the time stamp when the error was updated.
 */
public data class HealthErrorDetailsResponse(
    public val applianceName: String,
    public val code: String,
    public val discoveryScope: String,
    public val id: Double,
    public val message: String,
    public val messageParameters: Map<String, String>,
    public val possibleCauses: String,
    public val recommendedAction: String,
    public val runAsAccountId: String,
    public val severity: String,
    public val source: String,
    public val summaryMessage: String,
    public val updatedTimeStamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.offazure.outputs.HealthErrorDetailsResponse): HealthErrorDetailsResponse = HealthErrorDetailsResponse(
            applianceName = javaType.applianceName(),
            code = javaType.code(),
            discoveryScope = javaType.discoveryScope(),
            id = javaType.id(),
            message = javaType.message(),
            messageParameters = javaType.messageParameters().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            possibleCauses = javaType.possibleCauses(),
            recommendedAction = javaType.recommendedAction(),
            runAsAccountId = javaType.runAsAccountId(),
            severity = javaType.severity(),
            source = javaType.source(),
            summaryMessage = javaType.summaryMessage(),
            updatedTimeStamp = javaType.updatedTimeStamp(),
        )
    }
}
