@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property privateEndpoint
 * @property privateLinkServiceConnectionState
 * @property provisioningState
 */
public data class PrivateEndpointConnectionPropertiesResponse(
    public val privateEndpoint: ResourceIdResponse,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.offazure.outputs.PrivateEndpointConnectionPropertiesResponse): PrivateEndpointConnectionPropertiesResponse = PrivateEndpointConnectionPropertiesResponse(
            privateEndpoint = javaType.privateEndpoint().let({ args0 ->
                com.pulumi.azurenative.offazure.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
            }),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.offazure.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
