@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class for site appliance properties.
 * @property agentDetails Gets or sets the on-premises agent details.
 * @property applianceName Gets or sets the Appliance Name.
 * @property servicePrincipalIdentityDetails  Gets or sets the service principal identity details used by agent for  communication              to the service.
 */
public data class SiteAppliancePropertiesResponse(
    public val agentDetails: SiteAgentPropertiesResponse? = null,
    public val applianceName: String? = null,
    public val servicePrincipalIdentityDetails: SiteSpnPropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.offazure.outputs.SiteAppliancePropertiesResponse): SiteAppliancePropertiesResponse = SiteAppliancePropertiesResponse(
            agentDetails = javaType.agentDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.offazure.kotlin.outputs.SiteAgentPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            applianceName = javaType.applianceName().map({ args0 -> args0 }).orElse(null),
            servicePrincipalIdentityDetails = javaType.servicePrincipalIdentityDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.offazure.kotlin.outputs.SiteSpnPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
