@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin

import com.pulumi.azurenative.offazurespringboot.kotlin.outputs.SpringbootappsPropertiesResponse
import com.pulumi.azurenative.offazurespringboot.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.offazurespringboot.kotlin.outputs.SpringbootappsPropertiesResponse.Companion.toKotlin as springbootappsPropertiesResponseToKotlin
import com.pulumi.azurenative.offazurespringboot.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Springbootapp].
 */
@PulumiTagMarker
public class SpringbootappResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SpringbootappArgs = SpringbootappArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SpringbootappArgsBuilder.() -> Unit) {
        val builder = SpringbootappArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Springbootapp {
        val builtJavaResource =
            com.pulumi.azurenative.offazurespringboot.Springbootapp(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Springbootapp(builtJavaResource)
    }
}

/**
 * The springbootapps envelope resource definition.
 * Azure REST API version: 2024-04-01-preview.
 * ## Example Usage
 * ### springbootapps_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var springbootapp = new AzureNative.OffAzureSpringBoot.Springbootapp("springbootapp", new()
 *     {
 *         Properties = new AzureNative.OffAzureSpringBoot.Inputs.SpringbootappsPropertiesArgs
 *         {
 *             AppName = "wrauwfegjfccym",
 *             AppPort = 12,
 *             AppType = "axzunlh",
 *             ApplicationConfigurations = new[]
 *             {
 *                 new AzureNative.OffAzureSpringBoot.Inputs.SpringbootappsPropertiesApplicationConfigurationsArgs
 *                 {
 *                     Key = "wrbnwhqxjextxgdfbonuynvs",
 *                     Value = "jnmaf",
 *                 },
 *             },
 *             ArtifactName = "wrauwfegjfccym",
 *             BindingPorts = new[]
 *             {
 *                 11,
 *             },
 *             BuildJdkVersion = "ipzruwqqulkpvhzymqegntz",
 *             Certificates = new[]
 *             {
 *                 "xpiqqob",
 *             },
 *             Checksum = "gpzumvbzfnhhmuehveanctiamr",
 *             Dependencies = new[]
 *             {
 *                 "zrtted",
 *             },
 *             Environments = new[]
 *             {
 *                 "afhprevtcx",
 *             },
 *             InstanceCount = 5,
 *             Instances = new[]
 *             {
 *                 new AzureNative.OffAzureSpringBoot.Inputs.SpringbootappsPropertiesInstancesArgs
 *                 {
 *                     InstanceCount = 5,
 *                     JvmMemoryInMB = 128,
 *                     MachineArmId = "lsstlommxuskyhnwyxh",
 *                 },
 *             },
 *             JarFileLocation = "wfptqclncaqycyfbfih",
 *             JvmMemoryInMB = 1,
 *             JvmOptions = new[]
 *             {
 *                 "nytejjoytevmvlgnfwb",
 *             },
 *             LastModifiedTime = "2022-12-02T09:28:24.094Z",
 *             MachineArmIds = new[]
 *             {
 *                 "lsstlommxuskyhnwyxh",
 *             },
 *             Miscs = new[]
 *             {
 *                 new AzureNative.OffAzureSpringBoot.Inputs.SpringbootappsPropertiesMiscsArgs
 *                 {
 *                     Key = "fobsfetkynfmkziei",
 *                     Value = "k",
 *                 },
 *             },
 *             RuntimeJdkVersion = "eblzujbsulpeilykqyjso",
 *             Servers = new[]
 *             {
 *                 "gvfhsohasdx",
 *             },
 *             SpringBootVersion = "euggigfiii",
 *             StaticContentLocations = new[]
 *             {
 *                 "wvvajfkbtmjftir",
 *             },
 *         },
 *         ResourceGroupName = "rgspringbootapps",
 *         SiteName = "pdfosfhtemfsaglvwjdyqlyeipucrd",
 *         SpringbootappsName = "ofjeesoahqtnovlbuvflyknpbhcpeqqhekntvqxyemuwbcqnuxjgfhsf",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazurespringboot/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazurespringboot.NewSpringbootapp(ctx, "springbootapp", &offazurespringboot.SpringbootappArgs{
 * 			Properties: &offazurespringboot.SpringbootappsPropertiesArgs{
 * 				AppName: pulumi.String("wrauwfegjfccym"),
 * 				AppPort: pulumi.Int(12),
 * 				AppType: pulumi.String("axzunlh"),
 * 				ApplicationConfigurations: offazurespringboot.SpringbootappsPropertiesApplicationConfigurationsArray{
 * 					&offazurespringboot.SpringbootappsPropertiesApplicationConfigurationsArgs{
 * 						Key:   pulumi.String("wrbnwhqxjextxgdfbonuynvs"),
 * 						Value: pulumi.String("jnmaf"),
 * 					},
 * 				},
 * 				ArtifactName: pulumi.String("wrauwfegjfccym"),
 * 				BindingPorts: pulumi.IntArray{
 * 					pulumi.Int(11),
 * 				},
 * 				BuildJdkVersion: pulumi.String("ipzruwqqulkpvhzymqegntz"),
 * 				Certificates: pulumi.StringArray{
 * 					pulumi.String("xpiqqob"),
 * 				},
 * 				Checksum: pulumi.String("gpzumvbzfnhhmuehveanctiamr"),
 * 				Dependencies: pulumi.StringArray{
 * 					pulumi.String("zrtted"),
 * 				},
 * 				Environments: pulumi.StringArray{
 * 					pulumi.String("afhprevtcx"),
 * 				},
 * 				InstanceCount: pulumi.Int(5),
 * 				Instances: offazurespringboot.SpringbootappsPropertiesInstancesArray{
 * 					&offazurespringboot.SpringbootappsPropertiesInstancesArgs{
 * 						InstanceCount: pulumi.Int(5),
 * 						JvmMemoryInMB: pulumi.Int(128),
 * 						MachineArmId:  pulumi.String("lsstlommxuskyhnwyxh"),
 * 					},
 * 				},
 * 				JarFileLocation: pulumi.String("wfptqclncaqycyfbfih"),
 * 				JvmMemoryInMB:   pulumi.Int(1),
 * 				JvmOptions: pulumi.StringArray{
 * 					pulumi.String("nytejjoytevmvlgnfwb"),
 * 				},
 * 				LastModifiedTime: pulumi.String("2022-12-02T09:28:24.094Z"),
 * 				MachineArmIds: pulumi.StringArray{
 * 					pulumi.String("lsstlommxuskyhnwyxh"),
 * 				},
 * 				Miscs: offazurespringboot.SpringbootappsPropertiesMiscsArray{
 * 					&offazurespringboot.SpringbootappsPropertiesMiscsArgs{
 * 						Key:   pulumi.String("fobsfetkynfmkziei"),
 * 						Value: pulumi.String("k"),
 * 					},
 * 				},
 * 				RuntimeJdkVersion: pulumi.String("eblzujbsulpeilykqyjso"),
 * 				Servers: pulumi.StringArray{
 * 					pulumi.String("gvfhsohasdx"),
 * 				},
 * 				SpringBootVersion: pulumi.String("euggigfiii"),
 * 				StaticContentLocations: pulumi.StringArray{
 * 					pulumi.String("wvvajfkbtmjftir"),
 * 				},
 * 			},
 * 			ResourceGroupName:  pulumi.String("rgspringbootapps"),
 * 			SiteName:           pulumi.String("pdfosfhtemfsaglvwjdyqlyeipucrd"),
 * 			SpringbootappsName: pulumi.String("ofjeesoahqtnovlbuvflyknpbhcpeqqhekntvqxyemuwbcqnuxjgfhsf"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazurespringboot.Springbootapp;
 * import com.pulumi.azurenative.offazurespringboot.SpringbootappArgs;
 * import com.pulumi.azurenative.offazurespringboot.inputs.SpringbootappsPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var springbootapp = new Springbootapp("springbootapp", SpringbootappArgs.builder()
 *             .properties(SpringbootappsPropertiesArgs.builder()
 *                 .appName("wrauwfegjfccym")
 *                 .appPort(12)
 *                 .appType("axzunlh")
 *                 .applicationConfigurations(SpringbootappsPropertiesApplicationConfigurationsArgs.builder()
 *                     .key("wrbnwhqxjextxgdfbonuynvs")
 *                     .value("jnmaf")
 *                     .build())
 *                 .artifactName("wrauwfegjfccym")
 *                 .bindingPorts(11)
 *                 .buildJdkVersion("ipzruwqqulkpvhzymqegntz")
 *                 .certificates("xpiqqob")
 *                 .checksum("gpzumvbzfnhhmuehveanctiamr")
 *                 .dependencies("zrtted")
 *                 .environments("afhprevtcx")
 *                 .instanceCount(5)
 *                 .instances(SpringbootappsPropertiesInstancesArgs.builder()
 *                     .instanceCount(5)
 *                     .jvmMemoryInMB(128)
 *                     .machineArmId("lsstlommxuskyhnwyxh")
 *                     .build())
 *                 .jarFileLocation("wfptqclncaqycyfbfih")
 *                 .jvmMemoryInMB(1)
 *                 .jvmOptions("nytejjoytevmvlgnfwb")
 *                 .lastModifiedTime("2022-12-02T09:28:24.094Z")
 *                 .machineArmIds("lsstlommxuskyhnwyxh")
 *                 .miscs(SpringbootappsPropertiesMiscsArgs.builder()
 *                     .key("fobsfetkynfmkziei")
 *                     .value("k")
 *                     .build())
 *                 .runtimeJdkVersion("eblzujbsulpeilykqyjso")
 *                 .servers("gvfhsohasdx")
 *                 .springBootVersion("euggigfiii")
 *                 .staticContentLocations("wvvajfkbtmjftir")
 *                 .build())
 *             .resourceGroupName("rgspringbootapps")
 *             .siteName("pdfosfhtemfsaglvwjdyqlyeipucrd")
 *             .springbootappsName("ofjeesoahqtnovlbuvflyknpbhcpeqqhekntvqxyemuwbcqnuxjgfhsf")
 *             .build());
 *     }
 * }
 * ```
 * ### springbootapps_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var springbootapp = new AzureNative.OffAzureSpringBoot.Springbootapp("springbootapp", new()
 *     {
 *         ResourceGroupName = "rgspringbootapps",
 *         SiteName = "pdfosfhtemfsaglvwjdyqlyeipucrd",
 *         SpringbootappsName = "ofjeesoahqtnovlbuvflyknpbhcpeqqhekntvqxyemuwbcqnuxjgfhsf",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazurespringboot/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazurespringboot.NewSpringbootapp(ctx, "springbootapp", &offazurespringboot.SpringbootappArgs{
 * 			ResourceGroupName:  pulumi.String("rgspringbootapps"),
 * 			SiteName:           pulumi.String("pdfosfhtemfsaglvwjdyqlyeipucrd"),
 * 			SpringbootappsName: pulumi.String("ofjeesoahqtnovlbuvflyknpbhcpeqqhekntvqxyemuwbcqnuxjgfhsf"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazurespringboot.Springbootapp;
 * import com.pulumi.azurenative.offazurespringboot.SpringbootappArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var springbootapp = new Springbootapp("springbootapp", SpringbootappArgs.builder()
 *             .resourceGroupName("rgspringbootapps")
 *             .siteName("pdfosfhtemfsaglvwjdyqlyeipucrd")
 *             .springbootappsName("ofjeesoahqtnovlbuvflyknpbhcpeqqhekntvqxyemuwbcqnuxjgfhsf")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazurespringboot:Springbootapp enyeyrgonjdauhscqy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps/{springbootappsName}
 * ```
 */
public class Springbootapp internal constructor(
    override val javaResource: com.pulumi.azurenative.offazurespringboot.Springbootapp,
) : KotlinCustomResource(javaResource, SpringbootappMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The springbootapps resource definition.
     */
    public val properties: Output<SpringbootappsPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                springbootappsPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SpringbootappMapper : ResourceMapper<Springbootapp> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.offazurespringboot.Springbootapp::class == javaResource::class

    override fun map(javaResource: Resource): Springbootapp = Springbootapp(
        javaResource as
            com.pulumi.azurenative.offazurespringboot.Springbootapp,
    )
}

/**
 * @see [Springbootapp].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Springbootapp].
 */
public suspend fun springbootapp(
    name: String,
    block: suspend SpringbootappResourceBuilder.() -> Unit,
): Springbootapp {
    val builder = SpringbootappResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Springbootapp].
 * @param name The _unique_ name of the resulting resource.
 */
public fun springbootapp(name: String): Springbootapp {
    val builder = SpringbootappResourceBuilder()
    builder.name(name)
    return builder.build()
}
