@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin

import com.pulumi.azurenative.offazurespringboot.SpringbootappArgs.builder
import com.pulumi.azurenative.offazurespringboot.kotlin.inputs.SpringbootappsPropertiesArgs
import com.pulumi.azurenative.offazurespringboot.kotlin.inputs.SpringbootappsPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The springbootapps envelope resource definition.
 * Azure REST API version: 2024-04-01-preview.
 * ## Example Usage
 * ### springbootapps_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var springbootapp = new AzureNative.OffAzureSpringBoot.Springbootapp("springbootapp", new()
 *     {
 *         Properties = new AzureNative.OffAzureSpringBoot.Inputs.SpringbootappsPropertiesArgs
 *         {
 *             AppName = "wrauwfegjfccym",
 *             AppPort = 12,
 *             AppType = "axzunlh",
 *             ApplicationConfigurations = new[]
 *             {
 *                 new AzureNative.OffAzureSpringBoot.Inputs.SpringbootappsPropertiesApplicationConfigurationsArgs
 *                 {
 *                     Key = "wrbnwhqxjextxgdfbonuynvs",
 *                     Value = "jnmaf",
 *                 },
 *             },
 *             ArtifactName = "wrauwfegjfccym",
 *             BindingPorts = new[]
 *             {
 *                 11,
 *             },
 *             BuildJdkVersion = "ipzruwqqulkpvhzymqegntz",
 *             Certificates = new[]
 *             {
 *                 "xpiqqob",
 *             },
 *             Checksum = "gpzumvbzfnhhmuehveanctiamr",
 *             Dependencies = new[]
 *             {
 *                 "zrtted",
 *             },
 *             Environments = new[]
 *             {
 *                 "afhprevtcx",
 *             },
 *             InstanceCount = 5,
 *             Instances = new[]
 *             {
 *                 new AzureNative.OffAzureSpringBoot.Inputs.SpringbootappsPropertiesInstancesArgs
 *                 {
 *                     InstanceCount = 5,
 *                     JvmMemoryInMB = 128,
 *                     MachineArmId = "lsstlommxuskyhnwyxh",
 *                 },
 *             },
 *             JarFileLocation = "wfptqclncaqycyfbfih",
 *             JvmMemoryInMB = 1,
 *             JvmOptions = new[]
 *             {
 *                 "nytejjoytevmvlgnfwb",
 *             },
 *             LastModifiedTime = "2022-12-02T09:28:24.094Z",
 *             MachineArmIds = new[]
 *             {
 *                 "lsstlommxuskyhnwyxh",
 *             },
 *             Miscs = new[]
 *             {
 *                 new AzureNative.OffAzureSpringBoot.Inputs.SpringbootappsPropertiesMiscsArgs
 *                 {
 *                     Key = "fobsfetkynfmkziei",
 *                     Value = "k",
 *                 },
 *             },
 *             RuntimeJdkVersion = "eblzujbsulpeilykqyjso",
 *             Servers = new[]
 *             {
 *                 "gvfhsohasdx",
 *             },
 *             SpringBootVersion = "euggigfiii",
 *             StaticContentLocations = new[]
 *             {
 *                 "wvvajfkbtmjftir",
 *             },
 *         },
 *         ResourceGroupName = "rgspringbootapps",
 *         SiteName = "pdfosfhtemfsaglvwjdyqlyeipucrd",
 *         SpringbootappsName = "ofjeesoahqtnovlbuvflyknpbhcpeqqhekntvqxyemuwbcqnuxjgfhsf",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazurespringboot/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazurespringboot.NewSpringbootapp(ctx, "springbootapp", &offazurespringboot.SpringbootappArgs{
 * 			Properties: &offazurespringboot.SpringbootappsPropertiesArgs{
 * 				AppName: pulumi.String("wrauwfegjfccym"),
 * 				AppPort: pulumi.Int(12),
 * 				AppType: pulumi.String("axzunlh"),
 * 				ApplicationConfigurations: offazurespringboot.SpringbootappsPropertiesApplicationConfigurationsArray{
 * 					&offazurespringboot.SpringbootappsPropertiesApplicationConfigurationsArgs{
 * 						Key:   pulumi.String("wrbnwhqxjextxgdfbonuynvs"),
 * 						Value: pulumi.String("jnmaf"),
 * 					},
 * 				},
 * 				ArtifactName: pulumi.String("wrauwfegjfccym"),
 * 				BindingPorts: pulumi.IntArray{
 * 					pulumi.Int(11),
 * 				},
 * 				BuildJdkVersion: pulumi.String("ipzruwqqulkpvhzymqegntz"),
 * 				Certificates: pulumi.StringArray{
 * 					pulumi.String("xpiqqob"),
 * 				},
 * 				Checksum: pulumi.String("gpzumvbzfnhhmuehveanctiamr"),
 * 				Dependencies: pulumi.StringArray{
 * 					pulumi.String("zrtted"),
 * 				},
 * 				Environments: pulumi.StringArray{
 * 					pulumi.String("afhprevtcx"),
 * 				},
 * 				InstanceCount: pulumi.Int(5),
 * 				Instances: offazurespringboot.SpringbootappsPropertiesInstancesArray{
 * 					&offazurespringboot.SpringbootappsPropertiesInstancesArgs{
 * 						InstanceCount: pulumi.Int(5),
 * 						JvmMemoryInMB: pulumi.Int(128),
 * 						MachineArmId:  pulumi.String("lsstlommxuskyhnwyxh"),
 * 					},
 * 				},
 * 				JarFileLocation: pulumi.String("wfptqclncaqycyfbfih"),
 * 				JvmMemoryInMB:   pulumi.Int(1),
 * 				JvmOptions: pulumi.StringArray{
 * 					pulumi.String("nytejjoytevmvlgnfwb"),
 * 				},
 * 				LastModifiedTime: pulumi.String("2022-12-02T09:28:24.094Z"),
 * 				MachineArmIds: pulumi.StringArray{
 * 					pulumi.String("lsstlommxuskyhnwyxh"),
 * 				},
 * 				Miscs: offazurespringboot.SpringbootappsPropertiesMiscsArray{
 * 					&offazurespringboot.SpringbootappsPropertiesMiscsArgs{
 * 						Key:   pulumi.String("fobsfetkynfmkziei"),
 * 						Value: pulumi.String("k"),
 * 					},
 * 				},
 * 				RuntimeJdkVersion: pulumi.String("eblzujbsulpeilykqyjso"),
 * 				Servers: pulumi.StringArray{
 * 					pulumi.String("gvfhsohasdx"),
 * 				},
 * 				SpringBootVersion: pulumi.String("euggigfiii"),
 * 				StaticContentLocations: pulumi.StringArray{
 * 					pulumi.String("wvvajfkbtmjftir"),
 * 				},
 * 			},
 * 			ResourceGroupName:  pulumi.String("rgspringbootapps"),
 * 			SiteName:           pulumi.String("pdfosfhtemfsaglvwjdyqlyeipucrd"),
 * 			SpringbootappsName: pulumi.String("ofjeesoahqtnovlbuvflyknpbhcpeqqhekntvqxyemuwbcqnuxjgfhsf"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazurespringboot.Springbootapp;
 * import com.pulumi.azurenative.offazurespringboot.SpringbootappArgs;
 * import com.pulumi.azurenative.offazurespringboot.inputs.SpringbootappsPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var springbootapp = new Springbootapp("springbootapp", SpringbootappArgs.builder()
 *             .properties(SpringbootappsPropertiesArgs.builder()
 *                 .appName("wrauwfegjfccym")
 *                 .appPort(12)
 *                 .appType("axzunlh")
 *                 .applicationConfigurations(SpringbootappsPropertiesApplicationConfigurationsArgs.builder()
 *                     .key("wrbnwhqxjextxgdfbonuynvs")
 *                     .value("jnmaf")
 *                     .build())
 *                 .artifactName("wrauwfegjfccym")
 *                 .bindingPorts(11)
 *                 .buildJdkVersion("ipzruwqqulkpvhzymqegntz")
 *                 .certificates("xpiqqob")
 *                 .checksum("gpzumvbzfnhhmuehveanctiamr")
 *                 .dependencies("zrtted")
 *                 .environments("afhprevtcx")
 *                 .instanceCount(5)
 *                 .instances(SpringbootappsPropertiesInstancesArgs.builder()
 *                     .instanceCount(5)
 *                     .jvmMemoryInMB(128)
 *                     .machineArmId("lsstlommxuskyhnwyxh")
 *                     .build())
 *                 .jarFileLocation("wfptqclncaqycyfbfih")
 *                 .jvmMemoryInMB(1)
 *                 .jvmOptions("nytejjoytevmvlgnfwb")
 *                 .lastModifiedTime("2022-12-02T09:28:24.094Z")
 *                 .machineArmIds("lsstlommxuskyhnwyxh")
 *                 .miscs(SpringbootappsPropertiesMiscsArgs.builder()
 *                     .key("fobsfetkynfmkziei")
 *                     .value("k")
 *                     .build())
 *                 .runtimeJdkVersion("eblzujbsulpeilykqyjso")
 *                 .servers("gvfhsohasdx")
 *                 .springBootVersion("euggigfiii")
 *                 .staticContentLocations("wvvajfkbtmjftir")
 *                 .build())
 *             .resourceGroupName("rgspringbootapps")
 *             .siteName("pdfosfhtemfsaglvwjdyqlyeipucrd")
 *             .springbootappsName("ofjeesoahqtnovlbuvflyknpbhcpeqqhekntvqxyemuwbcqnuxjgfhsf")
 *             .build());
 *     }
 * }
 * ```
 * ### springbootapps_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var springbootapp = new AzureNative.OffAzureSpringBoot.Springbootapp("springbootapp", new()
 *     {
 *         ResourceGroupName = "rgspringbootapps",
 *         SiteName = "pdfosfhtemfsaglvwjdyqlyeipucrd",
 *         SpringbootappsName = "ofjeesoahqtnovlbuvflyknpbhcpeqqhekntvqxyemuwbcqnuxjgfhsf",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazurespringboot/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazurespringboot.NewSpringbootapp(ctx, "springbootapp", &offazurespringboot.SpringbootappArgs{
 * 			ResourceGroupName:  pulumi.String("rgspringbootapps"),
 * 			SiteName:           pulumi.String("pdfosfhtemfsaglvwjdyqlyeipucrd"),
 * 			SpringbootappsName: pulumi.String("ofjeesoahqtnovlbuvflyknpbhcpeqqhekntvqxyemuwbcqnuxjgfhsf"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazurespringboot.Springbootapp;
 * import com.pulumi.azurenative.offazurespringboot.SpringbootappArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var springbootapp = new Springbootapp("springbootapp", SpringbootappArgs.builder()
 *             .resourceGroupName("rgspringbootapps")
 *             .siteName("pdfosfhtemfsaglvwjdyqlyeipucrd")
 *             .springbootappsName("ofjeesoahqtnovlbuvflyknpbhcpeqqhekntvqxyemuwbcqnuxjgfhsf")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazurespringboot:Springbootapp enyeyrgonjdauhscqy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps/{springbootappsName}
 * ```
 * @property properties The springbootapps resource definition.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName The springbootsites name.
 * @property springbootappsName The springbootapps name.
 */
public data class SpringbootappArgs(
    public val properties: Output<SpringbootappsPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val siteName: Output<String>? = null,
    public val springbootappsName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazurespringboot.SpringbootappArgs> {
    override fun toJava(): com.pulumi.azurenative.offazurespringboot.SpringbootappArgs =
        com.pulumi.azurenative.offazurespringboot.SpringbootappArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteName(siteName?.applyValue({ args0 -> args0 }))
            .springbootappsName(springbootappsName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpringbootappArgs].
 */
@PulumiTagMarker
public class SpringbootappArgsBuilder internal constructor() {
    private var properties: Output<SpringbootappsPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var siteName: Output<String>? = null

    private var springbootappsName: Output<String>? = null

    /**
     * @param value The springbootapps resource definition.
     */
    @JvmName("vqnqrssjpgtrgixb")
    public suspend fun properties(`value`: Output<SpringbootappsPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("almobegqpaehkqnr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The springbootsites name.
     */
    @JvmName("aosteoqwtarnepfd")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value The springbootapps name.
     */
    @JvmName("yifkqqfcmmcvsnhv")
    public suspend fun springbootappsName(`value`: Output<String>) {
        this.springbootappsName = value
    }

    /**
     * @param value The springbootapps resource definition.
     */
    @JvmName("etdomaoetmeddwff")
    public suspend fun properties(`value`: SpringbootappsPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The springbootapps resource definition.
     */
    @JvmName("waanjiiflvjqjoci")
    public suspend fun properties(argument: suspend SpringbootappsPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SpringbootappsPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fxqoqocbxngfmmby")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The springbootsites name.
     */
    @JvmName("jbmseugeitlexckf")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value The springbootapps name.
     */
    @JvmName("lewnwrlrpflhqnbn")
    public suspend fun springbootappsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.springbootappsName = mapped
    }

    internal fun build(): SpringbootappArgs = SpringbootappArgs(
        properties = properties,
        resourceGroupName = resourceGroupName,
        siteName = siteName,
        springbootappsName = springbootappsName,
    )
}
