@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin.inputs

import com.pulumi.azurenative.offazurespringboot.inputs.ErrorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the error.
 * @property code The error code.
 * @property id The error ID.
 * @property message The detailed error message.
 * @property possibleCauses The error possible causes.
 * @property recommendedAction The error recommended action
 * @property runAsAccountId The account ID used to login.
 * @property severity The error severity
 * @property summaryMessage The summarized error message.
 * @property updatedTimeStamp Time when this error was last updated.
 */
public data class ErrorArgs(
    public val code: Output<String>? = null,
    public val id: Output<Double>? = null,
    public val message: Output<String>? = null,
    public val possibleCauses: Output<String>? = null,
    public val recommendedAction: Output<String>? = null,
    public val runAsAccountId: Output<String>? = null,
    public val severity: Output<String>? = null,
    public val summaryMessage: Output<String>? = null,
    public val updatedTimeStamp: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazurespringboot.inputs.ErrorArgs> {
    override fun toJava(): com.pulumi.azurenative.offazurespringboot.inputs.ErrorArgs =
        com.pulumi.azurenative.offazurespringboot.inputs.ErrorArgs.builder()
            .code(code?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .message(message?.applyValue({ args0 -> args0 }))
            .possibleCauses(possibleCauses?.applyValue({ args0 -> args0 }))
            .recommendedAction(recommendedAction?.applyValue({ args0 -> args0 }))
            .runAsAccountId(runAsAccountId?.applyValue({ args0 -> args0 }))
            .severity(severity?.applyValue({ args0 -> args0 }))
            .summaryMessage(summaryMessage?.applyValue({ args0 -> args0 }))
            .updatedTimeStamp(updatedTimeStamp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ErrorArgs].
 */
@PulumiTagMarker
public class ErrorArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    private var id: Output<Double>? = null

    private var message: Output<String>? = null

    private var possibleCauses: Output<String>? = null

    private var recommendedAction: Output<String>? = null

    private var runAsAccountId: Output<String>? = null

    private var severity: Output<String>? = null

    private var summaryMessage: Output<String>? = null

    private var updatedTimeStamp: Output<String>? = null

    /**
     * @param value The error code.
     */
    @JvmName("usbjsudbwckrshhf")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value The error ID.
     */
    @JvmName("rhljgktjaouakkcl")
    public suspend fun id(`value`: Output<Double>) {
        this.id = value
    }

    /**
     * @param value The detailed error message.
     */
    @JvmName("efcosotcmflalinj")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value The error possible causes.
     */
    @JvmName("mijogudoxplfymol")
    public suspend fun possibleCauses(`value`: Output<String>) {
        this.possibleCauses = value
    }

    /**
     * @param value The error recommended action
     */
    @JvmName("arfaodlbpgacsaoh")
    public suspend fun recommendedAction(`value`: Output<String>) {
        this.recommendedAction = value
    }

    /**
     * @param value The account ID used to login.
     */
    @JvmName("ixgomtnivsebeoem")
    public suspend fun runAsAccountId(`value`: Output<String>) {
        this.runAsAccountId = value
    }

    /**
     * @param value The error severity
     */
    @JvmName("xthnpwifovioodjv")
    public suspend fun severity(`value`: Output<String>) {
        this.severity = value
    }

    /**
     * @param value The summarized error message.
     */
    @JvmName("nndrctmgsdslaajk")
    public suspend fun summaryMessage(`value`: Output<String>) {
        this.summaryMessage = value
    }

    /**
     * @param value Time when this error was last updated.
     */
    @JvmName("oucftfagfcwmnxfe")
    public suspend fun updatedTimeStamp(`value`: Output<String>) {
        this.updatedTimeStamp = value
    }

    /**
     * @param value The error code.
     */
    @JvmName("gcqiuwixldilxbxf")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value The error ID.
     */
    @JvmName("xxlxfyuyqfedcuve")
    public suspend fun id(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The detailed error message.
     */
    @JvmName("avkgqkyimslsdtpt")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value The error possible causes.
     */
    @JvmName("ckeierimpybevrpv")
    public suspend fun possibleCauses(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.possibleCauses = mapped
    }

    /**
     * @param value The error recommended action
     */
    @JvmName("xldpbelcsbueteug")
    public suspend fun recommendedAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recommendedAction = mapped
    }

    /**
     * @param value The account ID used to login.
     */
    @JvmName("fegjauebciivxdox")
    public suspend fun runAsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsAccountId = mapped
    }

    /**
     * @param value The error severity
     */
    @JvmName("cswckvkhtbkefjkq")
    public suspend fun severity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severity = mapped
    }

    /**
     * @param value The summarized error message.
     */
    @JvmName("oispolyexwxrevao")
    public suspend fun summaryMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.summaryMessage = mapped
    }

    /**
     * @param value Time when this error was last updated.
     */
    @JvmName("oicnajlytianiusv")
    public suspend fun updatedTimeStamp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updatedTimeStamp = mapped
    }

    internal fun build(): ErrorArgs = ErrorArgs(
        code = code,
        id = id,
        message = message,
        possibleCauses = possibleCauses,
        recommendedAction = recommendedAction,
        runAsAccountId = runAsAccountId,
        severity = severity,
        summaryMessage = summaryMessage,
        updatedTimeStamp = updatedTimeStamp,
    )
}
