@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin.inputs

import com.pulumi.azurenative.offazurespringboot.inputs.GetSpringbootappPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName The springbootsites name.
 * @property springbootappsName The springbootapps name.
 */
public data class GetSpringbootappPlainArgs(
    public val resourceGroupName: String,
    public val siteName: String,
    public val springbootappsName: String,
) : ConvertibleToJava<com.pulumi.azurenative.offazurespringboot.inputs.GetSpringbootappPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.offazurespringboot.inputs.GetSpringbootappPlainArgs = com.pulumi.azurenative.offazurespringboot.inputs.GetSpringbootappPlainArgs.builder()
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
        .siteName(siteName.let({ args0 -> args0 }))
        .springbootappsName(springbootappsName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSpringbootappPlainArgs].
 */
@PulumiTagMarker
public class GetSpringbootappPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var siteName: String? = null

    private var springbootappsName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rjyktwxouxggmudk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The springbootsites name.
     */
    @JvmName("vtekrmxgnmxeicnx")
    public suspend fun siteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.siteName = mapped
    }

    /**
     * @param value The springbootapps name.
     */
    @JvmName("unwkfslnvshtbatc")
    public suspend fun springbootappsName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.springbootappsName = mapped
    }

    internal fun build(): GetSpringbootappPlainArgs = GetSpringbootappPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        siteName = siteName ?: throw PulumiNullFieldException("siteName"),
        springbootappsName = springbootappsName ?: throw PulumiNullFieldException("springbootappsName"),
    )
}
