@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin.inputs

import com.pulumi.azurenative.offazurespringboot.inputs.SpringbootappsPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The springbootapps resource definition.
 * @property appName The name of SpringBootApp.
 * @property appPort The application port.
 * @property appType The application type, whether it is a SpringBoot app.
 * @property applicationConfigurations The application configuration file list.
 * @property artifactName The artifact name of SpringBootApp.
 * @property bindingPorts The application binding port list.
 * @property buildJdkVersion The jdk version in build.
 * @property certificates The certificate file list.
 * @property checksum The checksum of jar file.
 * @property connectionStrings The connection string list.
 * @property dependencies The dependency list.
 * @property environments The environment variable list.
 * @property errors The list of errors.
 * @property instanceCount The total instance count the app deployed.
 * @property instances The breakdown info for app instances on all the servers
 * @property jarFileLocation The jar file location on the server.
 * @property jvmMemoryInMB The jvm heap memory allocated.
 * @property jvmOptions The jvm options.
 * @property labels Resource labels
 * @property lastModifiedTime Time when this springbootapps jar file was last modified.
 * @property lastUpdatedTime Time when this springbootapps instance was last refreshed.
 * @property machineArmIds The machine ARM id list the app belongs to.
 * @property miscs The other types of date collected.
 * @property runtimeJdkVersion The jdk version installed on server
 * @property servers The server list the app installed
 * @property springBootVersion The spring boot version.
 * @property staticContentLocations The static content location list.
 */
public data class SpringbootappsPropertiesArgs(
    public val appName: Output<String>? = null,
    public val appPort: Output<Int>? = null,
    public val appType: Output<String>? = null,
    public val applicationConfigurations: Output<List<SpringbootappsPropertiesApplicationConfigurationsArgs>>? = null,
    public val artifactName: Output<String>? = null,
    public val bindingPorts: Output<List<Int>>? = null,
    public val buildJdkVersion: Output<String>? = null,
    public val certificates: Output<List<String>>? = null,
    public val checksum: Output<String>? = null,
    public val connectionStrings: Output<List<String>>? = null,
    public val dependencies: Output<List<String>>? = null,
    public val environments: Output<List<String>>? = null,
    public val errors: Output<List<ErrorArgs>>? = null,
    public val instanceCount: Output<Int>? = null,
    public val instances: Output<List<SpringbootappsPropertiesInstancesArgs>>? = null,
    public val jarFileLocation: Output<String>? = null,
    public val jvmMemoryInMB: Output<Int>? = null,
    public val jvmOptions: Output<List<String>>? = null,
    public val labels: Output<Map<String, String>>? = null,
    public val lastModifiedTime: Output<String>? = null,
    public val lastUpdatedTime: Output<String>? = null,
    public val machineArmIds: Output<List<String>>? = null,
    public val miscs: Output<List<SpringbootappsPropertiesMiscsArgs>>? = null,
    public val runtimeJdkVersion: Output<String>? = null,
    public val servers: Output<List<String>>? = null,
    public val springBootVersion: Output<String>? = null,
    public val staticContentLocations: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazurespringboot.inputs.SpringbootappsPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.offazurespringboot.inputs.SpringbootappsPropertiesArgs =
        com.pulumi.azurenative.offazurespringboot.inputs.SpringbootappsPropertiesArgs.builder()
            .appName(appName?.applyValue({ args0 -> args0 }))
            .appPort(appPort?.applyValue({ args0 -> args0 }))
            .appType(appType?.applyValue({ args0 -> args0 }))
            .applicationConfigurations(
                applicationConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .artifactName(artifactName?.applyValue({ args0 -> args0 }))
            .bindingPorts(bindingPorts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .buildJdkVersion(buildJdkVersion?.applyValue({ args0 -> args0 }))
            .certificates(certificates?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .checksum(checksum?.applyValue({ args0 -> args0 }))
            .connectionStrings(connectionStrings?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .dependencies(dependencies?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .environments(environments?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .errors(errors?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .instances(
                instances?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .jarFileLocation(jarFileLocation?.applyValue({ args0 -> args0 }))
            .jvmMemoryInMB(jvmMemoryInMB?.applyValue({ args0 -> args0 }))
            .jvmOptions(jvmOptions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .lastModifiedTime(lastModifiedTime?.applyValue({ args0 -> args0 }))
            .lastUpdatedTime(lastUpdatedTime?.applyValue({ args0 -> args0 }))
            .machineArmIds(machineArmIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .miscs(miscs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .runtimeJdkVersion(runtimeJdkVersion?.applyValue({ args0 -> args0 }))
            .servers(servers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .springBootVersion(springBootVersion?.applyValue({ args0 -> args0 }))
            .staticContentLocations(
                staticContentLocations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [SpringbootappsPropertiesArgs].
 */
@PulumiTagMarker
public class SpringbootappsPropertiesArgsBuilder internal constructor() {
    private var appName: Output<String>? = null

    private var appPort: Output<Int>? = null

    private var appType: Output<String>? = null

    private var applicationConfigurations:
        Output<List<SpringbootappsPropertiesApplicationConfigurationsArgs>>? = null

    private var artifactName: Output<String>? = null

    private var bindingPorts: Output<List<Int>>? = null

    private var buildJdkVersion: Output<String>? = null

    private var certificates: Output<List<String>>? = null

    private var checksum: Output<String>? = null

    private var connectionStrings: Output<List<String>>? = null

    private var dependencies: Output<List<String>>? = null

    private var environments: Output<List<String>>? = null

    private var errors: Output<List<ErrorArgs>>? = null

    private var instanceCount: Output<Int>? = null

    private var instances: Output<List<SpringbootappsPropertiesInstancesArgs>>? = null

    private var jarFileLocation: Output<String>? = null

    private var jvmMemoryInMB: Output<Int>? = null

    private var jvmOptions: Output<List<String>>? = null

    private var labels: Output<Map<String, String>>? = null

    private var lastModifiedTime: Output<String>? = null

    private var lastUpdatedTime: Output<String>? = null

    private var machineArmIds: Output<List<String>>? = null

    private var miscs: Output<List<SpringbootappsPropertiesMiscsArgs>>? = null

    private var runtimeJdkVersion: Output<String>? = null

    private var servers: Output<List<String>>? = null

    private var springBootVersion: Output<String>? = null

    private var staticContentLocations: Output<List<String>>? = null

    /**
     * @param value The name of SpringBootApp.
     */
    @JvmName("lkvmipcyusbiktpu")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value The application port.
     */
    @JvmName("otaehrrsqowdkkkw")
    public suspend fun appPort(`value`: Output<Int>) {
        this.appPort = value
    }

    /**
     * @param value The application type, whether it is a SpringBoot app.
     */
    @JvmName("pnswolhgbtjapayt")
    public suspend fun appType(`value`: Output<String>) {
        this.appType = value
    }

    /**
     * @param value The application configuration file list.
     */
    @JvmName("mehkuonpkfsgfcve")
    public suspend fun applicationConfigurations(`value`: Output<List<SpringbootappsPropertiesApplicationConfigurationsArgs>>) {
        this.applicationConfigurations = value
    }

    @JvmName("csljkvhdatfwmwbk")
    public suspend fun applicationConfigurations(vararg values: Output<SpringbootappsPropertiesApplicationConfigurationsArgs>) {
        this.applicationConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The application configuration file list.
     */
    @JvmName("xsbwdtgbsvlotbeq")
    public suspend fun applicationConfigurations(values: List<Output<SpringbootappsPropertiesApplicationConfigurationsArgs>>) {
        this.applicationConfigurations = Output.all(values)
    }

    /**
     * @param value The artifact name of SpringBootApp.
     */
    @JvmName("flqacnygreovijoj")
    public suspend fun artifactName(`value`: Output<String>) {
        this.artifactName = value
    }

    /**
     * @param value The application binding port list.
     */
    @JvmName("vehdcetknwnlfjbv")
    public suspend fun bindingPorts(`value`: Output<List<Int>>) {
        this.bindingPorts = value
    }

    @JvmName("daqhrubqljkkwktp")
    public suspend fun bindingPorts(vararg values: Output<Int>) {
        this.bindingPorts = Output.all(values.asList())
    }

    /**
     * @param values The application binding port list.
     */
    @JvmName("iakadltkamchwuqg")
    public suspend fun bindingPorts(values: List<Output<Int>>) {
        this.bindingPorts = Output.all(values)
    }

    /**
     * @param value The jdk version in build.
     */
    @JvmName("vgqfpxbldjrcqxuk")
    public suspend fun buildJdkVersion(`value`: Output<String>) {
        this.buildJdkVersion = value
    }

    /**
     * @param value The certificate file list.
     */
    @JvmName("asofscrwewakrysc")
    public suspend fun certificates(`value`: Output<List<String>>) {
        this.certificates = value
    }

    @JvmName("uaxvbgjeaclnabey")
    public suspend fun certificates(vararg values: Output<String>) {
        this.certificates = Output.all(values.asList())
    }

    /**
     * @param values The certificate file list.
     */
    @JvmName("sgnkignfgwoshseb")
    public suspend fun certificates(values: List<Output<String>>) {
        this.certificates = Output.all(values)
    }

    /**
     * @param value The checksum of jar file.
     */
    @JvmName("sqiceorshvukiifl")
    public suspend fun checksum(`value`: Output<String>) {
        this.checksum = value
    }

    /**
     * @param value The connection string list.
     */
    @JvmName("kutxmwvwilrayxjq")
    public suspend fun connectionStrings(`value`: Output<List<String>>) {
        this.connectionStrings = value
    }

    @JvmName("lvhoyvutsqirtalm")
    public suspend fun connectionStrings(vararg values: Output<String>) {
        this.connectionStrings = Output.all(values.asList())
    }

    /**
     * @param values The connection string list.
     */
    @JvmName("etyygmifaetfkruf")
    public suspend fun connectionStrings(values: List<Output<String>>) {
        this.connectionStrings = Output.all(values)
    }

    /**
     * @param value The dependency list.
     */
    @JvmName("lkxyixpxorkaxblq")
    public suspend fun dependencies(`value`: Output<List<String>>) {
        this.dependencies = value
    }

    @JvmName("bfdobxttapeelrhx")
    public suspend fun dependencies(vararg values: Output<String>) {
        this.dependencies = Output.all(values.asList())
    }

    /**
     * @param values The dependency list.
     */
    @JvmName("meiurshkwoydstvb")
    public suspend fun dependencies(values: List<Output<String>>) {
        this.dependencies = Output.all(values)
    }

    /**
     * @param value The environment variable list.
     */
    @JvmName("xtywkrxenwyskpox")
    public suspend fun environments(`value`: Output<List<String>>) {
        this.environments = value
    }

    @JvmName("nljthjyoajvomivj")
    public suspend fun environments(vararg values: Output<String>) {
        this.environments = Output.all(values.asList())
    }

    /**
     * @param values The environment variable list.
     */
    @JvmName("wqptjqrnmilpjjsc")
    public suspend fun environments(values: List<Output<String>>) {
        this.environments = Output.all(values)
    }

    /**
     * @param value The list of errors.
     */
    @JvmName("qitrubdihenchbui")
    public suspend fun errors(`value`: Output<List<ErrorArgs>>) {
        this.errors = value
    }

    @JvmName("ujrqvydhnbuadjnn")
    public suspend fun errors(vararg values: Output<ErrorArgs>) {
        this.errors = Output.all(values.asList())
    }

    /**
     * @param values The list of errors.
     */
    @JvmName("colkbtrrmqenuorn")
    public suspend fun errors(values: List<Output<ErrorArgs>>) {
        this.errors = Output.all(values)
    }

    /**
     * @param value The total instance count the app deployed.
     */
    @JvmName("nfmnspnqagfbywyu")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value The breakdown info for app instances on all the servers
     */
    @JvmName("dclpmslbwandfeni")
    public suspend fun instances(`value`: Output<List<SpringbootappsPropertiesInstancesArgs>>) {
        this.instances = value
    }

    @JvmName("eysurxbfbvwixhwe")
    public suspend fun instances(vararg values: Output<SpringbootappsPropertiesInstancesArgs>) {
        this.instances = Output.all(values.asList())
    }

    /**
     * @param values The breakdown info for app instances on all the servers
     */
    @JvmName("skjubxstyhxnhxki")
    public suspend fun instances(values: List<Output<SpringbootappsPropertiesInstancesArgs>>) {
        this.instances = Output.all(values)
    }

    /**
     * @param value The jar file location on the server.
     */
    @JvmName("ixeouakfbhbftltl")
    public suspend fun jarFileLocation(`value`: Output<String>) {
        this.jarFileLocation = value
    }

    /**
     * @param value The jvm heap memory allocated.
     */
    @JvmName("hbqrpqqbftdravej")
    public suspend fun jvmMemoryInMB(`value`: Output<Int>) {
        this.jvmMemoryInMB = value
    }

    /**
     * @param value The jvm options.
     */
    @JvmName("umwkccmhvlongtim")
    public suspend fun jvmOptions(`value`: Output<List<String>>) {
        this.jvmOptions = value
    }

    @JvmName("mersugitfvpyvkko")
    public suspend fun jvmOptions(vararg values: Output<String>) {
        this.jvmOptions = Output.all(values.asList())
    }

    /**
     * @param values The jvm options.
     */
    @JvmName("yurkdabxfasggyoe")
    public suspend fun jvmOptions(values: List<Output<String>>) {
        this.jvmOptions = Output.all(values)
    }

    /**
     * @param value Resource labels
     */
    @JvmName("kqevgmwvghythwvt")
    public suspend fun labels(`value`: Output<Map<String, String>>) {
        this.labels = value
    }

    /**
     * @param value Time when this springbootapps jar file was last modified.
     */
    @JvmName("yewxlwknpvrngnfq")
    public suspend fun lastModifiedTime(`value`: Output<String>) {
        this.lastModifiedTime = value
    }

    /**
     * @param value Time when this springbootapps instance was last refreshed.
     */
    @JvmName("ymjmnacuxhdcqgtw")
    public suspend fun lastUpdatedTime(`value`: Output<String>) {
        this.lastUpdatedTime = value
    }

    /**
     * @param value The machine ARM id list the app belongs to.
     */
    @JvmName("qaqhahgacmcdqiaw")
    public suspend fun machineArmIds(`value`: Output<List<String>>) {
        this.machineArmIds = value
    }

    @JvmName("aknskufcjtqcxfta")
    public suspend fun machineArmIds(vararg values: Output<String>) {
        this.machineArmIds = Output.all(values.asList())
    }

    /**
     * @param values The machine ARM id list the app belongs to.
     */
    @JvmName("kueyksywdisnxapm")
    public suspend fun machineArmIds(values: List<Output<String>>) {
        this.machineArmIds = Output.all(values)
    }

    /**
     * @param value The other types of date collected.
     */
    @JvmName("ltxiwwhexnqwrqfe")
    public suspend fun miscs(`value`: Output<List<SpringbootappsPropertiesMiscsArgs>>) {
        this.miscs = value
    }

    @JvmName("yyykqvldaidgmvwi")
    public suspend fun miscs(vararg values: Output<SpringbootappsPropertiesMiscsArgs>) {
        this.miscs = Output.all(values.asList())
    }

    /**
     * @param values The other types of date collected.
     */
    @JvmName("jafjycjmcgupouqg")
    public suspend fun miscs(values: List<Output<SpringbootappsPropertiesMiscsArgs>>) {
        this.miscs = Output.all(values)
    }

    /**
     * @param value The jdk version installed on server
     */
    @JvmName("skhnudahnsghutnh")
    public suspend fun runtimeJdkVersion(`value`: Output<String>) {
        this.runtimeJdkVersion = value
    }

    /**
     * @param value The server list the app installed
     */
    @JvmName("ofyyuvfugmcpisrf")
    public suspend fun servers(`value`: Output<List<String>>) {
        this.servers = value
    }

    @JvmName("jcodxdpadjqwhjgx")
    public suspend fun servers(vararg values: Output<String>) {
        this.servers = Output.all(values.asList())
    }

    /**
     * @param values The server list the app installed
     */
    @JvmName("oiarepjwjbseglnl")
    public suspend fun servers(values: List<Output<String>>) {
        this.servers = Output.all(values)
    }

    /**
     * @param value The spring boot version.
     */
    @JvmName("gbwfneoxhryepnrl")
    public suspend fun springBootVersion(`value`: Output<String>) {
        this.springBootVersion = value
    }

    /**
     * @param value The static content location list.
     */
    @JvmName("fneittdghyqdvnjo")
    public suspend fun staticContentLocations(`value`: Output<List<String>>) {
        this.staticContentLocations = value
    }

    @JvmName("ixctxdswjwpslayu")
    public suspend fun staticContentLocations(vararg values: Output<String>) {
        this.staticContentLocations = Output.all(values.asList())
    }

    /**
     * @param values The static content location list.
     */
    @JvmName("gcvrvywvanbjkcfo")
    public suspend fun staticContentLocations(values: List<Output<String>>) {
        this.staticContentLocations = Output.all(values)
    }

    /**
     * @param value The name of SpringBootApp.
     */
    @JvmName("tflavhtmmrkuiyxr")
    public suspend fun appName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value The application port.
     */
    @JvmName("egbxkrptlvunbhek")
    public suspend fun appPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appPort = mapped
    }

    /**
     * @param value The application type, whether it is a SpringBoot app.
     */
    @JvmName("brgrjyulgnjgqvwy")
    public suspend fun appType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appType = mapped
    }

    /**
     * @param value The application configuration file list.
     */
    @JvmName("ixiwcolikvdhojke")
    public suspend fun applicationConfigurations(`value`: List<SpringbootappsPropertiesApplicationConfigurationsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationConfigurations = mapped
    }

    /**
     * @param argument The application configuration file list.
     */
    @JvmName("iftdrcngcljtssgl")
    public suspend fun applicationConfigurations(argument: List<suspend SpringbootappsPropertiesApplicationConfigurationsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SpringbootappsPropertiesApplicationConfigurationsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationConfigurations = mapped
    }

    /**
     * @param argument The application configuration file list.
     */
    @JvmName("bjmbljaxudtngsux")
    public suspend fun applicationConfigurations(vararg argument: suspend SpringbootappsPropertiesApplicationConfigurationsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SpringbootappsPropertiesApplicationConfigurationsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationConfigurations = mapped
    }

    /**
     * @param argument The application configuration file list.
     */
    @JvmName("bvilpioyfdjotuwm")
    public suspend fun applicationConfigurations(argument: suspend SpringbootappsPropertiesApplicationConfigurationsArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                SpringbootappsPropertiesApplicationConfigurationsArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.applicationConfigurations = mapped
    }

    /**
     * @param values The application configuration file list.
     */
    @JvmName("dytugkyebfkrvrwj")
    public suspend fun applicationConfigurations(vararg values: SpringbootappsPropertiesApplicationConfigurationsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationConfigurations = mapped
    }

    /**
     * @param value The artifact name of SpringBootApp.
     */
    @JvmName("sbehukuylqrrkrdp")
    public suspend fun artifactName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactName = mapped
    }

    /**
     * @param value The application binding port list.
     */
    @JvmName("bqomjesviignbmmd")
    public suspend fun bindingPorts(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindingPorts = mapped
    }

    /**
     * @param values The application binding port list.
     */
    @JvmName("fevxnyenltoytciw")
    public suspend fun bindingPorts(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bindingPorts = mapped
    }

    /**
     * @param value The jdk version in build.
     */
    @JvmName("pvaikxkwtjdvyvms")
    public suspend fun buildJdkVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildJdkVersion = mapped
    }

    /**
     * @param value The certificate file list.
     */
    @JvmName("qioyfytsuplsebff")
    public suspend fun certificates(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param values The certificate file list.
     */
    @JvmName("rlduktgaxcuiusng")
    public suspend fun certificates(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param value The checksum of jar file.
     */
    @JvmName("cvauaewvstwtpbie")
    public suspend fun checksum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checksum = mapped
    }

    /**
     * @param value The connection string list.
     */
    @JvmName("fvjbhufqamscsjhl")
    public suspend fun connectionStrings(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionStrings = mapped
    }

    /**
     * @param values The connection string list.
     */
    @JvmName("tgnglmoixtclddxj")
    public suspend fun connectionStrings(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionStrings = mapped
    }

    /**
     * @param value The dependency list.
     */
    @JvmName("kjnjrxqtidknukos")
    public suspend fun dependencies(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependencies = mapped
    }

    /**
     * @param values The dependency list.
     */
    @JvmName("jxjcmlcvsspwtmoj")
    public suspend fun dependencies(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependencies = mapped
    }

    /**
     * @param value The environment variable list.
     */
    @JvmName("bceyjfmhyqagxtop")
    public suspend fun environments(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environments = mapped
    }

    /**
     * @param values The environment variable list.
     */
    @JvmName("gshcmbvquaeuwjvl")
    public suspend fun environments(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environments = mapped
    }

    /**
     * @param value The list of errors.
     */
    @JvmName("fuxuaqjshvyvcolb")
    public suspend fun errors(`value`: List<ErrorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errors = mapped
    }

    /**
     * @param argument The list of errors.
     */
    @JvmName("jcqfqfgymkcbabse")
    public suspend fun errors(argument: List<suspend ErrorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ErrorArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.errors = mapped
    }

    /**
     * @param argument The list of errors.
     */
    @JvmName("cyrnovusnjnfnfwx")
    public suspend fun errors(vararg argument: suspend ErrorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ErrorArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.errors = mapped
    }

    /**
     * @param argument The list of errors.
     */
    @JvmName("mwjiaiikhqnmxhjj")
    public suspend fun errors(argument: suspend ErrorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ErrorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.errors = mapped
    }

    /**
     * @param values The list of errors.
     */
    @JvmName("cyjtofkbqulwjykg")
    public suspend fun errors(vararg values: ErrorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.errors = mapped
    }

    /**
     * @param value The total instance count the app deployed.
     */
    @JvmName("xmnnlltaahmqclpa")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value The breakdown info for app instances on all the servers
     */
    @JvmName("ckgtseqbsgupttfx")
    public suspend fun instances(`value`: List<SpringbootappsPropertiesInstancesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param argument The breakdown info for app instances on all the servers
     */
    @JvmName("jphhjqjuylhfulsu")
    public suspend fun instances(argument: List<suspend SpringbootappsPropertiesInstancesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SpringbootappsPropertiesInstancesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instances = mapped
    }

    /**
     * @param argument The breakdown info for app instances on all the servers
     */
    @JvmName("ipbrkpqgqvjuowpb")
    public suspend fun instances(vararg argument: suspend SpringbootappsPropertiesInstancesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SpringbootappsPropertiesInstancesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instances = mapped
    }

    /**
     * @param argument The breakdown info for app instances on all the servers
     */
    @JvmName("qxjguqsttwxevrte")
    public suspend fun instances(argument: suspend SpringbootappsPropertiesInstancesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SpringbootappsPropertiesInstancesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.instances = mapped
    }

    /**
     * @param values The breakdown info for app instances on all the servers
     */
    @JvmName("asmcxwtnqoxknipp")
    public suspend fun instances(vararg values: SpringbootappsPropertiesInstancesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param value The jar file location on the server.
     */
    @JvmName("jsybcewkjidlbmes")
    public suspend fun jarFileLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jarFileLocation = mapped
    }

    /**
     * @param value The jvm heap memory allocated.
     */
    @JvmName("ruqcewqrljydfjdl")
    public suspend fun jvmMemoryInMB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jvmMemoryInMB = mapped
    }

    /**
     * @param value The jvm options.
     */
    @JvmName("aqguyfkroxivqoea")
    public suspend fun jvmOptions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jvmOptions = mapped
    }

    /**
     * @param values The jvm options.
     */
    @JvmName("aesqfjwtehvnxmmm")
    public suspend fun jvmOptions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jvmOptions = mapped
    }

    /**
     * @param value Resource labels
     */
    @JvmName("ixguyenfamxtcskh")
    public suspend fun labels(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values Resource labels
     */
    @JvmName("otyjisdevmtxsjms")
    public fun labels(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value Time when this springbootapps jar file was last modified.
     */
    @JvmName("akpehuufjjrasamj")
    public suspend fun lastModifiedTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastModifiedTime = mapped
    }

    /**
     * @param value Time when this springbootapps instance was last refreshed.
     */
    @JvmName("xodvgsilqevtwbxm")
    public suspend fun lastUpdatedTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastUpdatedTime = mapped
    }

    /**
     * @param value The machine ARM id list the app belongs to.
     */
    @JvmName("ygftxjjqcqkgpaae")
    public suspend fun machineArmIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineArmIds = mapped
    }

    /**
     * @param values The machine ARM id list the app belongs to.
     */
    @JvmName("ycwkfamsnjwrcfvr")
    public suspend fun machineArmIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.machineArmIds = mapped
    }

    /**
     * @param value The other types of date collected.
     */
    @JvmName("vhbhshdkgupgvhxl")
    public suspend fun miscs(`value`: List<SpringbootappsPropertiesMiscsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.miscs = mapped
    }

    /**
     * @param argument The other types of date collected.
     */
    @JvmName("uoiwubrmcajfewmr")
    public suspend fun miscs(argument: List<suspend SpringbootappsPropertiesMiscsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SpringbootappsPropertiesMiscsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.miscs = mapped
    }

    /**
     * @param argument The other types of date collected.
     */
    @JvmName("wkhnsmstmoaucsbn")
    public suspend fun miscs(vararg argument: suspend SpringbootappsPropertiesMiscsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SpringbootappsPropertiesMiscsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.miscs = mapped
    }

    /**
     * @param argument The other types of date collected.
     */
    @JvmName("lsyymgwgernnsooi")
    public suspend fun miscs(argument: suspend SpringbootappsPropertiesMiscsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SpringbootappsPropertiesMiscsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.miscs = mapped
    }

    /**
     * @param values The other types of date collected.
     */
    @JvmName("ahtridylrpecgurv")
    public suspend fun miscs(vararg values: SpringbootappsPropertiesMiscsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.miscs = mapped
    }

    /**
     * @param value The jdk version installed on server
     */
    @JvmName("sqijpgsnmatfqmli")
    public suspend fun runtimeJdkVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeJdkVersion = mapped
    }

    /**
     * @param value The server list the app installed
     */
    @JvmName("qvflmlkmkvvelpxj")
    public suspend fun servers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servers = mapped
    }

    /**
     * @param values The server list the app installed
     */
    @JvmName("pfwgdrxuprfgibus")
    public suspend fun servers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servers = mapped
    }

    /**
     * @param value The spring boot version.
     */
    @JvmName("utqcaagmrnvhxhfn")
    public suspend fun springBootVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.springBootVersion = mapped
    }

    /**
     * @param value The static content location list.
     */
    @JvmName("orcbpmlrsaybonwi")
    public suspend fun staticContentLocations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticContentLocations = mapped
    }

    /**
     * @param values The static content location list.
     */
    @JvmName("pidcspjnfdgivfyi")
    public suspend fun staticContentLocations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.staticContentLocations = mapped
    }

    internal fun build(): SpringbootappsPropertiesArgs = SpringbootappsPropertiesArgs(
        appName = appName,
        appPort = appPort,
        appType = appType,
        applicationConfigurations = applicationConfigurations,
        artifactName = artifactName,
        bindingPorts = bindingPorts,
        buildJdkVersion = buildJdkVersion,
        certificates = certificates,
        checksum = checksum,
        connectionStrings = connectionStrings,
        dependencies = dependencies,
        environments = environments,
        errors = errors,
        instanceCount = instanceCount,
        instances = instances,
        jarFileLocation = jarFileLocation,
        jvmMemoryInMB = jvmMemoryInMB,
        jvmOptions = jvmOptions,
        labels = labels,
        lastModifiedTime = lastModifiedTime,
        lastUpdatedTime = lastUpdatedTime,
        machineArmIds = machineArmIds,
        miscs = miscs,
        runtimeJdkVersion = runtimeJdkVersion,
        servers = servers,
        springBootVersion = springBootVersion,
        staticContentLocations = staticContentLocations,
    )
}
