@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Defines the error.
 * @property code The error code.
 * @property id The error ID.
 * @property message The detailed error message.
 * @property possibleCauses The error possible causes.
 * @property recommendedAction The error recommended action
 * @property runAsAccountId The account ID used to login.
 * @property severity The error severity
 * @property summaryMessage The summarized error message.
 * @property updatedTimeStamp Time when this error was last updated.
 */
public data class ErrorResponse(
    public val code: String? = null,
    public val id: Double? = null,
    public val message: String? = null,
    public val possibleCauses: String? = null,
    public val recommendedAction: String? = null,
    public val runAsAccountId: String? = null,
    public val severity: String? = null,
    public val summaryMessage: String? = null,
    public val updatedTimeStamp: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.offazurespringboot.outputs.ErrorResponse): ErrorResponse = ErrorResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            possibleCauses = javaType.possibleCauses().map({ args0 -> args0 }).orElse(null),
            recommendedAction = javaType.recommendedAction().map({ args0 -> args0 }).orElse(null),
            runAsAccountId = javaType.runAsAccountId().map({ args0 -> args0 }).orElse(null),
            severity = javaType.severity().map({ args0 -> args0 }).orElse(null),
            summaryMessage = javaType.summaryMessage().map({ args0 -> args0 }).orElse(null),
            updatedTimeStamp = javaType.updatedTimeStamp().map({ args0 -> args0 }).orElse(null),
        )
    }
}
