@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The springbootservers resource definition.
 * @property errors The list of errors.
 * @property fqdnAndIpAddressList The alternative FQDN or IP addresses to discover for this server
 * @property machineArmId The machine Id from ARM
 * @property port Target server port for remote login
 * @property provisioningState The resource provisioning state.
 * @property server Server is the target server name or ip address to discover of SpringBootServer.
 * @property springBootApps The total number of spring boot apps been discovered
 * @property totalApps The total number of apps been discovered
 */
public data class SpringbootserversPropertiesResponse(
    public val errors: List<ErrorResponse>? = null,
    public val fqdnAndIpAddressList: List<String>? = null,
    public val machineArmId: String? = null,
    public val port: Int? = null,
    public val provisioningState: String? = null,
    public val server: String,
    public val springBootApps: Int? = null,
    public val totalApps: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.offazurespringboot.outputs.SpringbootserversPropertiesResponse): SpringbootserversPropertiesResponse = SpringbootserversPropertiesResponse(
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.offazurespringboot.kotlin.outputs.ErrorResponse.Companion.toKotlin(args0)
                })
            }),
            fqdnAndIpAddressList = javaType.fqdnAndIpAddressList().map({ args0 -> args0 }),
            machineArmId = javaType.machineArmId().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            server = javaType.server(),
            springBootApps = javaType.springBootApps().map({ args0 -> args0 }).orElse(null),
            totalApps = javaType.totalApps().map({ args0 -> args0 }).orElse(null),
        )
    }
}
