@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.openenergyplatform.kotlin

import com.pulumi.azurenative.openenergyplatform.kotlin.outputs.EnergyServicePropertiesResponse
import com.pulumi.azurenative.openenergyplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.openenergyplatform.kotlin.outputs.EnergyServicePropertiesResponse.Companion.toKotlin as energyServicePropertiesResponseToKotlin
import com.pulumi.azurenative.openenergyplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [EnergyService].
 */
@PulumiTagMarker
public class EnergyServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnergyServiceArgs = EnergyServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnergyServiceArgsBuilder.() -> Unit) {
        val builder = EnergyServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EnergyService {
        val builtJavaResource =
            com.pulumi.azurenative.openenergyplatform.EnergyService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EnergyService(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2022-04-04-preview. Prior API version in Azure Native 1.x: 2022-04-04-preview.
 * ## Example Usage
 * ### OepResource_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var energyService = new AzureNative.OpenEnergyPlatform.EnergyService("energyService", new()
 *     {
 *         ResourceGroupName = "DummyResourceGroupName",
 *         ResourceName = "DummyResourceName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/openenergyplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := openenergyplatform.NewEnergyService(ctx, "energyService", &openenergyplatform.EnergyServiceArgs{
 * 			ResourceGroupName: pulumi.String("DummyResourceGroupName"),
 * 			ResourceName:      pulumi.String("DummyResourceName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.openenergyplatform.EnergyService;
 * import com.pulumi.azurenative.openenergyplatform.EnergyServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var energyService = new EnergyService("energyService", EnergyServiceArgs.builder()
 *             .resourceGroupName("DummyResourceGroupName")
 *             .resourceName("DummyResourceName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:openenergyplatform:EnergyService DummyResourceName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OpenEnergyPlatform/energyServices/{resourceName}
 * ```
 */
public class EnergyService internal constructor(
    override val javaResource: com.pulumi.azurenative.openenergyplatform.EnergyService,
) : KotlinCustomResource(javaResource, EnergyServiceMapper) {
    /**
     * Geo-location where the resource lives.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<EnergyServicePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                energyServicePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EnergyServiceMapper : ResourceMapper<EnergyService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.openenergyplatform.EnergyService::class == javaResource::class

    override fun map(javaResource: Resource): EnergyService = EnergyService(
        javaResource as
            com.pulumi.azurenative.openenergyplatform.EnergyService,
    )
}

/**
 * @see [EnergyService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnergyService].
 */
public suspend fun energyService(
    name: String,
    block: suspend EnergyServiceResourceBuilder.() -> Unit,
): EnergyService {
    val builder = EnergyServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnergyService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun energyService(name: String): EnergyService {
    val builder = EnergyServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
