@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.openenergyplatform.kotlin.inputs

import com.pulumi.azurenative.openenergyplatform.inputs.EnergyServicePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property authAppId
 * @property dataPartitionNames
 */
public data class EnergyServicePropertiesArgs(
    public val authAppId: Output<String>? = null,
    public val dataPartitionNames: Output<List<DataPartitionNamesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.openenergyplatform.inputs.EnergyServicePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.openenergyplatform.inputs.EnergyServicePropertiesArgs =
        com.pulumi.azurenative.openenergyplatform.inputs.EnergyServicePropertiesArgs.builder()
            .authAppId(authAppId?.applyValue({ args0 -> args0 }))
            .dataPartitionNames(
                dataPartitionNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [EnergyServicePropertiesArgs].
 */
@PulumiTagMarker
public class EnergyServicePropertiesArgsBuilder internal constructor() {
    private var authAppId: Output<String>? = null

    private var dataPartitionNames: Output<List<DataPartitionNamesArgs>>? = null

    /**
     * @param value
     */
    @JvmName("voeusfhoigcibybj")
    public suspend fun authAppId(`value`: Output<String>) {
        this.authAppId = value
    }

    /**
     * @param value
     */
    @JvmName("ssjmrkbxeduyvdpg")
    public suspend fun dataPartitionNames(`value`: Output<List<DataPartitionNamesArgs>>) {
        this.dataPartitionNames = value
    }

    @JvmName("hdmanbccxsgwryut")
    public suspend fun dataPartitionNames(vararg values: Output<DataPartitionNamesArgs>) {
        this.dataPartitionNames = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("gopfpkyyjfpsxjnc")
    public suspend fun dataPartitionNames(values: List<Output<DataPartitionNamesArgs>>) {
        this.dataPartitionNames = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("scmvpumeiaihsscm")
    public suspend fun authAppId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authAppId = mapped
    }

    /**
     * @param value
     */
    @JvmName("gogycgrhhqmpxcxe")
    public suspend fun dataPartitionNames(`value`: List<DataPartitionNamesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPartitionNames = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rpntqdednpolstkj")
    public suspend fun dataPartitionNames(argument: List<suspend DataPartitionNamesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataPartitionNamesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataPartitionNames = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ajjlwawdywtclmxq")
    public suspend fun dataPartitionNames(vararg argument: suspend DataPartitionNamesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataPartitionNamesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataPartitionNames = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jadygayjqogkgknc")
    public suspend fun dataPartitionNames(argument: suspend DataPartitionNamesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataPartitionNamesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataPartitionNames = mapped
    }

    /**
     * @param values
     */
    @JvmName("hsarqaqtqhyirxad")
    public suspend fun dataPartitionNames(vararg values: DataPartitionNamesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataPartitionNames = mapped
    }

    internal fun build(): EnergyServicePropertiesArgs = EnergyServicePropertiesArgs(
        authAppId = authAppId,
        dataPartitionNames = dataPartitionNames,
    )
}
