@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.openenergyplatform.kotlin.inputs

import com.pulumi.azurenative.openenergyplatform.inputs.GetEnergyServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The resource name.
 */
public data class GetEnergyServicePlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.openenergyplatform.inputs.GetEnergyServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.openenergyplatform.inputs.GetEnergyServicePlainArgs = com.pulumi.azurenative.openenergyplatform.inputs.GetEnergyServicePlainArgs.builder()
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
        .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEnergyServicePlainArgs].
 */
@PulumiTagMarker
public class GetEnergyServicePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vuvvyhmefmbtmqou")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource name.
     */
    @JvmName("dxmaeiyyhgrgouiy")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetEnergyServicePlainArgs = GetEnergyServicePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
