@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.openenergyplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the properties of an individual data partition.
 * @property name Name of the data partition
 * @property provisioningState Name of the data partition
 */
public data class DataPartitionPropertiesResponse(
    public val name: String? = null,
    public val provisioningState: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.openenergyplatform.outputs.DataPartitionPropertiesResponse): DataPartitionPropertiesResponse = DataPartitionPropertiesResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
        )
    }
}
