@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.openenergyplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property authAppId
 * @property dataPartitionNames
 * @property dnsName
 * @property provisioningState
 */
public data class EnergyServicePropertiesResponse(
    public val authAppId: String? = null,
    public val dataPartitionNames: List<DataPartitionNamesResponse>? = null,
    public val dnsName: String,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.openenergyplatform.outputs.EnergyServicePropertiesResponse): EnergyServicePropertiesResponse = EnergyServicePropertiesResponse(
            authAppId = javaType.authAppId().map({ args0 -> args0 }).orElse(null),
            dataPartitionNames = javaType.dataPartitionNames().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.openenergyplatform.kotlin.outputs.DataPartitionNamesResponse.Companion.toKotlin(args0)
                })
            }),
            dnsName = javaType.dnsName(),
            provisioningState = javaType.provisioningState(),
        )
    }
}
