@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DataSource].
 */
@PulumiTagMarker
public class DataSourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataSourceArgs = DataSourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataSourceArgsBuilder.() -> Unit) {
        val builder = DataSourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataSource {
        val builtJavaResource =
            com.pulumi.azurenative.operationalinsights.DataSource(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataSource(builtJavaResource)
    }
}

/**
 * Datasources under OMS Workspace.
 * Azure REST API version: 2020-08-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * Other available API versions: 2015-11-01-preview.
 * ## Example Usage
 * ### DataSourcesCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataSource = new AzureNative.OperationalInsights.DataSource("dataSource", new()
 *     {
 *         DataSourceName = "AzTestDS774",
 *         Kind = AzureNative.OperationalInsights.DataSourceKind.AzureActivityLog,
 *         Properties = new Dictionary<string, object?>
 *         {
 *             ["LinkedResourceId"] = "/subscriptions/00000000-0000-0000-0000-00000000000/providers/microsoft.insights/eventtypes/management",
 *         },
 *         ResourceGroupName = "OIAutoRest5123",
 *         WorkspaceName = "AzTest9724",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewDataSource(ctx, "dataSource", &operationalinsights.DataSourceArgs{
 * 			DataSourceName: pulumi.String("AzTestDS774"),
 * 			Kind:           pulumi.String(operationalinsights.DataSourceKindAzureActivityLog),
 * 			Properties: pulumi.Any(map[string]interface{}{
 * 				"LinkedResourceId": "/subscriptions/00000000-0000-0000-0000-00000000000/providers/microsoft.insights/eventtypes/management",
 * 			}),
 * 			ResourceGroupName: pulumi.String("OIAutoRest5123"),
 * 			WorkspaceName:     pulumi.String("AzTest9724"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.DataSource;
 * import com.pulumi.azurenative.operationalinsights.DataSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataSource = new DataSource("dataSource", DataSourceArgs.builder()
 *             .dataSourceName("AzTestDS774")
 *             .kind("AzureActivityLog")
 *             .properties(Map.of("LinkedResourceId", "/subscriptions/00000000-0000-0000-0000-00000000000/providers/microsoft.insights/eventtypes/management"))
 *             .resourceGroupName("OIAutoRest5123")
 *             .workspaceName("AzTest9724")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:DataSource AzTestDS774 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/dataSources/{dataSourceName}
 * ```
 */
public class DataSource internal constructor(
    override val javaResource: com.pulumi.azurenative.operationalinsights.DataSource,
) : KotlinCustomResource(javaResource, DataSourceMapper) {
    /**
     * The ETag of the data source.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The kind of the DataSource.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The data source properties in raw json format, each kind of data source have it's own schema.
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataSourceMapper : ResourceMapper<DataSource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.operationalinsights.DataSource::class == javaResource::class

    override fun map(javaResource: Resource): DataSource = DataSource(
        javaResource as
            com.pulumi.azurenative.operationalinsights.DataSource,
    )
}

/**
 * @see [DataSource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataSource].
 */
public suspend fun dataSource(name: String, block: suspend DataSourceResourceBuilder.() -> Unit): DataSource {
    val builder = DataSourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataSource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataSource(name: String): DataSource {
    val builder = DataSourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
