@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [QueryPack].
 */
@PulumiTagMarker
public class QueryPackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QueryPackArgs = QueryPackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QueryPackArgsBuilder.() -> Unit) {
        val builder = QueryPackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): QueryPack {
        val builtJavaResource =
            com.pulumi.azurenative.operationalinsights.QueryPack(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return QueryPack(builtJavaResource)
    }
}

/**
 * An Log Analytics QueryPack definition.
 * Azure REST API version: 2019-09-01. Prior API version in Azure Native 1.x: 2019-09-01.
 * Other available API versions: 2019-09-01-preview.
 * ## Example Usage
 * ### QueryPackCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queryPack = new AzureNative.OperationalInsights.QueryPack("queryPack", new()
 *     {
 *         Location = "South Central US",
 *         QueryPackName = "my-querypack",
 *         ResourceGroupName = "my-resource-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewQueryPack(ctx, "queryPack", &operationalinsights.QueryPackArgs{
 * 			Location:          pulumi.String("South Central US"),
 * 			QueryPackName:     pulumi.String("my-querypack"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.QueryPack;
 * import com.pulumi.azurenative.operationalinsights.QueryPackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queryPack = new QueryPack("queryPack", QueryPackArgs.builder()
 *             .location("South Central US")
 *             .queryPackName("my-querypack")
 *             .resourceGroupName("my-resource-group")
 *             .build());
 *     }
 * }
 * ```
 * ### QueryPackUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queryPack = new AzureNative.OperationalInsights.QueryPack("queryPack", new()
 *     {
 *         Location = "South Central US",
 *         QueryPackName = "my-querypack",
 *         ResourceGroupName = "my-resource-group",
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewQueryPack(ctx, "queryPack", &operationalinsights.QueryPackArgs{
 * 			Location:          pulumi.String("South Central US"),
 * 			QueryPackName:     pulumi.String("my-querypack"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.QueryPack;
 * import com.pulumi.azurenative.operationalinsights.QueryPackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queryPack = new QueryPack("queryPack", QueryPackArgs.builder()
 *             .location("South Central US")
 *             .queryPackName("my-querypack")
 *             .resourceGroupName("my-resource-group")
 *             .tags(Map.of("Tag1", "Value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:QueryPack my-querypack /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}
 * ```
 */
public class QueryPack internal constructor(
    override val javaResource: com.pulumi.azurenative.operationalinsights.QueryPack,
) : KotlinCustomResource(javaResource, QueryPackMapper) {
    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Azure resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Current state of this QueryPack: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The unique ID of your application. This field cannot be changed.
     */
    public val queryPackId: Output<String>
        get() = javaResource.queryPackId().applyValue({ args0 -> args0 })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Creation Date for the Log Analytics QueryPack, in ISO 8601 format.
     */
    public val timeCreated: Output<String>
        get() = javaResource.timeCreated().applyValue({ args0 -> args0 })

    /**
     * Last modified date of the Log Analytics QueryPack, in ISO 8601 format.
     */
    public val timeModified: Output<String>
        get() = javaResource.timeModified().applyValue({ args0 -> args0 })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object QueryPackMapper : ResourceMapper<QueryPack> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.operationalinsights.QueryPack::class == javaResource::class

    override fun map(javaResource: Resource): QueryPack = QueryPack(
        javaResource as
            com.pulumi.azurenative.operationalinsights.QueryPack,
    )
}

/**
 * @see [QueryPack].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [QueryPack].
 */
public suspend fun queryPack(name: String, block: suspend QueryPackResourceBuilder.() -> Unit): QueryPack {
    val builder = QueryPackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [QueryPack].
 * @param name The _unique_ name of the resulting resource.
 */
public fun queryPack(name: String): QueryPack {
    val builder = QueryPackResourceBuilder()
    builder.name(name)
    return builder.build()
}
