@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.QueryPackArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Log Analytics QueryPack definition.
 * Azure REST API version: 2019-09-01. Prior API version in Azure Native 1.x: 2019-09-01.
 * Other available API versions: 2019-09-01-preview.
 * ## Example Usage
 * ### QueryPackCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queryPack = new AzureNative.OperationalInsights.QueryPack("queryPack", new()
 *     {
 *         Location = "South Central US",
 *         QueryPackName = "my-querypack",
 *         ResourceGroupName = "my-resource-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewQueryPack(ctx, "queryPack", &operationalinsights.QueryPackArgs{
 * 			Location:          pulumi.String("South Central US"),
 * 			QueryPackName:     pulumi.String("my-querypack"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.QueryPack;
 * import com.pulumi.azurenative.operationalinsights.QueryPackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queryPack = new QueryPack("queryPack", QueryPackArgs.builder()
 *             .location("South Central US")
 *             .queryPackName("my-querypack")
 *             .resourceGroupName("my-resource-group")
 *             .build());
 *     }
 * }
 * ```
 * ### QueryPackUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queryPack = new AzureNative.OperationalInsights.QueryPack("queryPack", new()
 *     {
 *         Location = "South Central US",
 *         QueryPackName = "my-querypack",
 *         ResourceGroupName = "my-resource-group",
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewQueryPack(ctx, "queryPack", &operationalinsights.QueryPackArgs{
 * 			Location:          pulumi.String("South Central US"),
 * 			QueryPackName:     pulumi.String("my-querypack"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.QueryPack;
 * import com.pulumi.azurenative.operationalinsights.QueryPackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queryPack = new QueryPack("queryPack", QueryPackArgs.builder()
 *             .location("South Central US")
 *             .queryPackName("my-querypack")
 *             .resourceGroupName("my-resource-group")
 *             .tags(Map.of("Tag1", "Value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:QueryPack my-querypack /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}
 * ```
 * @property location Resource location
 * @property queryPackName The name of the Log Analytics QueryPack resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags
 */
public data class QueryPackArgs(
    public val location: Output<String>? = null,
    public val queryPackName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.QueryPackArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.QueryPackArgs =
        com.pulumi.azurenative.operationalinsights.QueryPackArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .queryPackName(queryPackName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [QueryPackArgs].
 */
@PulumiTagMarker
public class QueryPackArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var queryPackName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource location
     */
    @JvmName("oprpnjjdpbkewsem")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the Log Analytics QueryPack resource.
     */
    @JvmName("lpysxiyxiqccgxnc")
    public suspend fun queryPackName(`value`: Output<String>) {
        this.queryPackName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pmpitxxsyrsdyore")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("jtypgbugppydstro")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("ebhetskxhegfivvo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the Log Analytics QueryPack resource.
     */
    @JvmName("bxfodpailtjgegja")
    public suspend fun queryPackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryPackName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sopjabvhmbifilnd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("mosyvbwkbwcfkxsv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("qgyqbllwwctbvhru")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): QueryPackArgs = QueryPackArgs(
        location = location,
        queryPackName = queryPackName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
