@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.kotlin.outputs.TagResponse
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.TagResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SavedSearch].
 */
@PulumiTagMarker
public class SavedSearchResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SavedSearchArgs = SavedSearchArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SavedSearchArgsBuilder.() -> Unit) {
        val builder = SavedSearchArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SavedSearch {
        val builtJavaResource =
            com.pulumi.azurenative.operationalinsights.SavedSearch(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SavedSearch(builtJavaResource)
    }
}

/**
 * Value object for saved search results.
 * Azure REST API version: 2020-08-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * Other available API versions: 2015-03-20.
 * ## Example Usage
 * ### SavedSearchCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var savedSearch = new AzureNative.OperationalInsights.SavedSearch("savedSearch", new()
 *     {
 *         Category = "Saved Search Test Category",
 *         DisplayName = "Create or Update Saved Search Test",
 *         FunctionAlias = "heartbeat_func",
 *         FunctionParameters = "a:int=1",
 *         Query = "Heartbeat | summarize Count() by Computer | take a",
 *         ResourceGroupName = "TestRG",
 *         SavedSearchId = "00000000-0000-0000-0000-00000000000",
 *         Tags = new[]
 *         {
 *             new AzureNative.OperationalInsights.Inputs.TagArgs
 *             {
 *                 Name = "Group",
 *                 Value = "Computer",
 *             },
 *         },
 *         Version = 2,
 *         WorkspaceName = "TestWS",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewSavedSearch(ctx, "savedSearch", &operationalinsights.SavedSearchArgs{
 * 			Category:           pulumi.String("Saved Search Test Category"),
 * 			DisplayName:        pulumi.String("Create or Update Saved Search Test"),
 * 			FunctionAlias:      pulumi.String("heartbeat_func"),
 * 			FunctionParameters: pulumi.String("a:int=1"),
 * 			Query:              pulumi.String("Heartbeat | summarize Count() by Computer | take a"),
 * 			ResourceGroupName:  pulumi.String("TestRG"),
 * 			SavedSearchId:      pulumi.String("00000000-0000-0000-0000-00000000000"),
 * 			Tags: operationalinsights.TagArray{
 * 				&operationalinsights.TagArgs{
 * 					Name:  pulumi.String("Group"),
 * 					Value: pulumi.String("Computer"),
 * 				},
 * 			},
 * 			Version:       pulumi.Float64(2),
 * 			WorkspaceName: pulumi.String("TestWS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.SavedSearch;
 * import com.pulumi.azurenative.operationalinsights.SavedSearchArgs;
 * import com.pulumi.azurenative.operationalinsights.inputs.TagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var savedSearch = new SavedSearch("savedSearch", SavedSearchArgs.builder()
 *             .category("Saved Search Test Category")
 *             .displayName("Create or Update Saved Search Test")
 *             .functionAlias("heartbeat_func")
 *             .functionParameters("a:int=1")
 *             .query("Heartbeat | summarize Count() by Computer | take a")
 *             .resourceGroupName("TestRG")
 *             .savedSearchId("00000000-0000-0000-0000-00000000000")
 *             .tags(TagArgs.builder()
 *                 .name("Group")
 *                 .value("Computer")
 *                 .build())
 *             .version(2)
 *             .workspaceName("TestWS")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:SavedSearch myresource1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/savedSearches/{savedSearchId}
 * ```
 */
public class SavedSearch internal constructor(
    override val javaResource: com.pulumi.azurenative.operationalinsights.SavedSearch,
) : KotlinCustomResource(javaResource, SavedSearchMapper) {
    /**
     * The category of the saved search. This helps the user to find a saved search faster.
     */
    public val category: Output<String>
        get() = javaResource.category().applyValue({ args0 -> args0 })

    /**
     * Saved search display name.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * The ETag of the saved search. To override an existing saved search, use "*" or specify the current Etag
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The function alias if query serves as a function.
     */
    public val functionAlias: Output<String>?
        get() = javaResource.functionAlias().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The optional function parameters if query serves as a function. Value should be in the following format: 'param-name1:type1 = default_value1, param-name2:type2 = default_value2'. For more examples and proper syntax please refer to https://docs.microsoft.com/en-us/azure/kusto/query/functions/user-defined-functions.
     */
    public val functionParameters: Output<String>?
        get() = javaResource.functionParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The query expression for the saved search.
     */
    public val query: Output<String>
        get() = javaResource.query().applyValue({ args0 -> args0 })

    /**
     * The tags attached to the saved search.
     */
    public val tags: Output<List<TagResponse>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The version number of the query language. The current version is 2 and is the default.
     */
    public val version: Output<Double>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object SavedSearchMapper : ResourceMapper<SavedSearch> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.operationalinsights.SavedSearch::class == javaResource::class

    override fun map(javaResource: Resource): SavedSearch = SavedSearch(
        javaResource as
            com.pulumi.azurenative.operationalinsights.SavedSearch,
    )
}

/**
 * @see [SavedSearch].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SavedSearch].
 */
public suspend fun savedSearch(name: String, block: suspend SavedSearchResourceBuilder.() -> Unit): SavedSearch {
    val builder = SavedSearchResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SavedSearch].
 * @param name The _unique_ name of the resulting resource.
 */
public fun savedSearch(name: String): SavedSearch {
    val builder = SavedSearchResourceBuilder()
    builder.name(name)
    return builder.build()
}
