@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.kotlin.outputs.StorageAccountResponse
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.StorageInsightStatusResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.StorageAccountResponse.Companion.toKotlin as storageAccountResponseToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.StorageInsightStatusResponse.Companion.toKotlin as storageInsightStatusResponseToKotlin

/**
 * Builder for [StorageInsightConfig].
 */
@PulumiTagMarker
public class StorageInsightConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageInsightConfigArgs = StorageInsightConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageInsightConfigArgsBuilder.() -> Unit) {
        val builder = StorageInsightConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StorageInsightConfig {
        val builtJavaResource =
            com.pulumi.azurenative.operationalinsights.StorageInsightConfig(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StorageInsightConfig(builtJavaResource)
    }
}

/**
 * The top level storage insight resource container.
 * Azure REST API version: 2020-08-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * ## Example Usage
 * ### StorageInsightsCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageInsightConfig = new AzureNative.OperationalInsights.StorageInsightConfig("storageInsightConfig", new()
 *     {
 *         Containers = new[]
 *         {
 *             "wad-iis-logfiles",
 *         },
 *         ResourceGroupName = "OIAutoRest5123",
 *         StorageAccount = new AzureNative.OperationalInsights.Inputs.StorageAccountArgs
 *         {
 *             Id = "/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/OIAutoRest6987/providers/microsoft.storage/storageaccounts/AzTestFakeSA9945",
 *             Key = "1234",
 *         },
 *         StorageInsightName = "AzTestSI1110",
 *         Tables = new[]
 *         {
 *             "WADWindowsEventLogsTable",
 *             "LinuxSyslogVer2v0",
 *         },
 *         WorkspaceName = "aztest5048",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewStorageInsightConfig(ctx, "storageInsightConfig", &operationalinsights.StorageInsightConfigArgs{
 * 			Containers: pulumi.StringArray{
 * 				pulumi.String("wad-iis-logfiles"),
 * 			},
 * 			ResourceGroupName: pulumi.String("OIAutoRest5123"),
 * 			StorageAccount: &operationalinsights.StorageAccountArgs{
 * 				Id:  pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/OIAutoRest6987/providers/microsoft.storage/storageaccounts/AzTestFakeSA9945"),
 * 				Key: pulumi.String("1234"),
 * 			},
 * 			StorageInsightName: pulumi.String("AzTestSI1110"),
 * 			Tables: pulumi.StringArray{
 * 				pulumi.String("WADWindowsEventLogsTable"),
 * 				pulumi.String("LinuxSyslogVer2v0"),
 * 			},
 * 			WorkspaceName: pulumi.String("aztest5048"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.StorageInsightConfig;
 * import com.pulumi.azurenative.operationalinsights.StorageInsightConfigArgs;
 * import com.pulumi.azurenative.operationalinsights.inputs.StorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageInsightConfig = new StorageInsightConfig("storageInsightConfig", StorageInsightConfigArgs.builder()
 *             .containers("wad-iis-logfiles")
 *             .resourceGroupName("OIAutoRest5123")
 *             .storageAccount(StorageAccountArgs.builder()
 *                 .id("/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/OIAutoRest6987/providers/microsoft.storage/storageaccounts/AzTestFakeSA9945")
 *                 .key("1234")
 *                 .build())
 *             .storageInsightName("AzTestSI1110")
 *             .tables(
 *                 "WADWindowsEventLogsTable",
 *                 "LinuxSyslogVer2v0")
 *             .workspaceName("aztest5048")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:StorageInsightConfig AzTestSI1110 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/storageInsightConfigs/{storageInsightName}
 * ```
 */
public class StorageInsightConfig internal constructor(
    override val javaResource: com.pulumi.azurenative.operationalinsights.StorageInsightConfig,
) : KotlinCustomResource(javaResource, StorageInsightConfigMapper) {
    /**
     * The names of the blob containers that the workspace should read
     */
    public val containers: Output<List<String>>?
        get() = javaResource.containers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The ETag of the storage insight.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the storage insight
     */
    public val status: Output<StorageInsightStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                storageInsightStatusResponseToKotlin(args0)
            })
        })

    /**
     * The storage account connection details
     */
    public val storageAccount: Output<StorageAccountResponse>
        get() = javaResource.storageAccount().applyValue({ args0 ->
            args0.let({ args0 ->
                storageAccountResponseToKotlin(args0)
            })
        })

    /**
     * The names of the Azure tables that the workspace should read
     */
    public val tables: Output<List<String>>?
        get() = javaResource.tables().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StorageInsightConfigMapper : ResourceMapper<StorageInsightConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.operationalinsights.StorageInsightConfig::class == javaResource::class

    override fun map(javaResource: Resource): StorageInsightConfig = StorageInsightConfig(
        javaResource
            as com.pulumi.azurenative.operationalinsights.StorageInsightConfig,
    )
}

/**
 * @see [StorageInsightConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StorageInsightConfig].
 */
public suspend fun storageInsightConfig(
    name: String,
    block: suspend StorageInsightConfigResourceBuilder.() -> Unit,
): StorageInsightConfig {
    val builder = StorageInsightConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StorageInsightConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storageInsightConfig(name: String): StorageInsightConfig {
    val builder = StorageInsightConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
