@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Column data type logical hint.
 */
public enum class ColumnDataTypeHintEnum(
    public val javaValue: com.pulumi.azurenative.operationalinsights.enums.ColumnDataTypeHintEnum,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.enums.ColumnDataTypeHintEnum> {
    /**
     * A string that matches the pattern of a URI, for example, scheme://username:password@host:1234/this/is/a/path?k1=v1&k2=v2#fragment
     */
    Uri(com.pulumi.azurenative.operationalinsights.enums.ColumnDataTypeHintEnum.Uri),

    /**
     * A standard 128-bit GUID following the standard shape, xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
     */
    Guid(com.pulumi.azurenative.operationalinsights.enums.ColumnDataTypeHintEnum.Guid),

    /**
     * An Azure Resource Model (ARM) path: /subscriptions/{...}/resourceGroups/{...}/providers/Microsoft.{...}/{...}/{...}/{...}...
     */
    ArmPath(com.pulumi.azurenative.operationalinsights.enums.ColumnDataTypeHintEnum.ArmPath),

    /**
     * A standard V4/V6 ip address following the standard shape, x.x.x.x/y:y:y:y:y:y:y:y
     */
    Ip(com.pulumi.azurenative.operationalinsights.enums.ColumnDataTypeHintEnum.Ip),
    ;

    override fun toJava(): com.pulumi.azurenative.operationalinsights.enums.ColumnDataTypeHintEnum =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.enums.ColumnDataTypeHintEnum): ColumnDataTypeHintEnum = ColumnDataTypeHintEnum.values().first { it.javaValue == javaType }
    }
}
