@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Instruct the system how to handle and charge the logs ingested to this table.
 */
public enum class TablePlanEnum(
    public val javaValue: com.pulumi.azurenative.operationalinsights.enums.TablePlanEnum,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.enums.TablePlanEnum> {
    /**
     * Logs  that are adjusted to support high volume low value verbose logs.
     */
    Basic(com.pulumi.azurenative.operationalinsights.enums.TablePlanEnum.Basic),

    /**
     * Logs  that allow monitoring and analytics.
     */
    Analytics(com.pulumi.azurenative.operationalinsights.enums.TablePlanEnum.Analytics),
    ;

    override fun toJava(): com.pulumi.azurenative.operationalinsights.enums.TablePlanEnum = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.enums.TablePlanEnum): TablePlanEnum = TablePlanEnum.values().first { it.javaValue == javaType }
    }
}
