@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.ColumnArgs.builder
import com.pulumi.azurenative.operationalinsights.kotlin.enums.ColumnDataTypeHintEnum
import com.pulumi.azurenative.operationalinsights.kotlin.enums.ColumnTypeEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Table column.
 * @property dataTypeHint Column data type logical hint.
 * @property description Column description.
 * @property displayName Column display name.
 * @property name Column name.
 * @property type Column data type.
 */
public data class ColumnArgs(
    public val dataTypeHint: Output<Either<String, ColumnDataTypeHintEnum>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val type: Output<Either<String, ColumnTypeEnum>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.ColumnArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.inputs.ColumnArgs =
        com.pulumi.azurenative.operationalinsights.inputs.ColumnArgs.builder()
            .dataTypeHint(
                dataTypeHint?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ColumnArgs].
 */
@PulumiTagMarker
public class ColumnArgsBuilder internal constructor() {
    private var dataTypeHint: Output<Either<String, ColumnDataTypeHintEnum>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var name: Output<String>? = null

    private var type: Output<Either<String, ColumnTypeEnum>>? = null

    /**
     * @param value Column data type logical hint.
     */
    @JvmName("rvlkfvkpyelonxvm")
    public suspend fun dataTypeHint(`value`: Output<Either<String, ColumnDataTypeHintEnum>>) {
        this.dataTypeHint = value
    }

    /**
     * @param value Column description.
     */
    @JvmName("rqfaohrbdjotrifr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Column display name.
     */
    @JvmName("ybwjvxqytocbhabs")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Column name.
     */
    @JvmName("cgxjiaodtnjuequl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Column data type.
     */
    @JvmName("msrqpeljslpbvipv")
    public suspend fun type(`value`: Output<Either<String, ColumnTypeEnum>>) {
        this.type = value
    }

    /**
     * @param value Column data type logical hint.
     */
    @JvmName("tvbmfxdglkvagkge")
    public suspend fun dataTypeHint(`value`: Either<String, ColumnDataTypeHintEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataTypeHint = mapped
    }

    /**
     * @param value Column data type logical hint.
     */
    @JvmName("nptaenldlhfwivro")
    public fun dataTypeHint(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ColumnDataTypeHintEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataTypeHint = mapped
    }

    /**
     * @param value Column data type logical hint.
     */
    @JvmName("boyfpgwficumykxq")
    public fun dataTypeHint(`value`: ColumnDataTypeHintEnum) {
        val toBeMapped = Either.ofRight<String, ColumnDataTypeHintEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataTypeHint = mapped
    }

    /**
     * @param value Column description.
     */
    @JvmName("mxpgwcfoojyckhtv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Column display name.
     */
    @JvmName("avafwtqbkwouasgf")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Column name.
     */
    @JvmName("iyoihnfjtlgbomaa")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Column data type.
     */
    @JvmName("qndpvctfjqwcfapc")
    public suspend fun type(`value`: Either<String, ColumnTypeEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Column data type.
     */
    @JvmName("ttwlqxbwwuqbirgf")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ColumnTypeEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Column data type.
     */
    @JvmName("waybmvfkbkfmxttg")
    public fun type(`value`: ColumnTypeEnum) {
        val toBeMapped = Either.ofRight<String, ColumnTypeEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ColumnArgs = ColumnArgs(
        dataTypeHint = dataTypeHint,
        description = description,
        displayName = displayName,
        name = name,
        type = type,
    )
}
