@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.GetStorageInsightConfigPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageInsightName Name of the storageInsightsConfigs resource
 * @property workspaceName The name of the workspace.
 */
public data class GetStorageInsightConfigPlainArgs(
    public val resourceGroupName: String,
    public val storageInsightName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.GetStorageInsightConfigPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.inputs.GetStorageInsightConfigPlainArgs =
        com.pulumi.azurenative.operationalinsights.inputs.GetStorageInsightConfigPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageInsightName(storageInsightName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStorageInsightConfigPlainArgs].
 */
@PulumiTagMarker
public class GetStorageInsightConfigPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var storageInsightName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ajojadwksrulugcb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the storageInsightsConfigs resource
     */
    @JvmName("uncgqbhhtqsvbgqe")
    public suspend fun storageInsightName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageInsightName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("dictjkartbqxijmx")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetStorageInsightConfigPlainArgs = GetStorageInsightConfigPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageInsightName = storageInsightName ?: throw PulumiNullFieldException("storageInsightName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
