@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.KeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The key vault properties.
 * @property keyName The name of the key associated with the Log Analytics cluster.
 * @property keyRsaSize Selected key minimum required size.
 * @property keyVaultUri The Key Vault uri which holds they key associated with the Log Analytics cluster.
 * @property keyVersion The version of the key associated with the Log Analytics cluster.
 */
public data class KeyVaultPropertiesArgs(
    public val keyName: Output<String>? = null,
    public val keyRsaSize: Output<Int>? = null,
    public val keyVaultUri: Output<String>? = null,
    public val keyVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.KeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.inputs.KeyVaultPropertiesArgs =
        com.pulumi.azurenative.operationalinsights.inputs.KeyVaultPropertiesArgs.builder()
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .keyRsaSize(keyRsaSize?.applyValue({ args0 -> args0 }))
            .keyVaultUri(keyVaultUri?.applyValue({ args0 -> args0 }))
            .keyVersion(keyVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultPropertiesArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var keyRsaSize: Output<Int>? = null

    private var keyVaultUri: Output<String>? = null

    private var keyVersion: Output<String>? = null

    /**
     * @param value The name of the key associated with the Log Analytics cluster.
     */
    @JvmName("asiahfmprxpbewbe")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value Selected key minimum required size.
     */
    @JvmName("ehybkxfdowsxbvcw")
    public suspend fun keyRsaSize(`value`: Output<Int>) {
        this.keyRsaSize = value
    }

    /**
     * @param value The Key Vault uri which holds they key associated with the Log Analytics cluster.
     */
    @JvmName("rrpbcoyhjwqtiliw")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value The version of the key associated with the Log Analytics cluster.
     */
    @JvmName("nxiddcuobnafumts")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value The name of the key associated with the Log Analytics cluster.
     */
    @JvmName("vascfhkmhviejhwl")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value Selected key minimum required size.
     */
    @JvmName("bfblvearbpvkpakb")
    public suspend fun keyRsaSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyRsaSize = mapped
    }

    /**
     * @param value The Key Vault uri which holds they key associated with the Log Analytics cluster.
     */
    @JvmName("wegoyicybvylsqnc")
    public suspend fun keyVaultUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    /**
     * @param value The version of the key associated with the Log Analytics cluster.
     */
    @JvmName("clowtwijordslmbl")
    public suspend fun keyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    internal fun build(): KeyVaultPropertiesArgs = KeyVaultPropertiesArgs(
        keyName = keyName,
        keyRsaSize = keyRsaSize,
        keyVaultUri = keyVaultUri,
        keyVersion = keyVersion,
    )
}
