@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.TagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A tag of a saved search.
 * @property name The tag name.
 * @property value The tag value.
 */
public data class TagArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.TagArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.inputs.TagArgs =
        com.pulumi.azurenative.operationalinsights.inputs.TagArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagArgs].
 */
@PulumiTagMarker
public class TagArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The tag name.
     */
    @JvmName("otdqephxjdpcwmsn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The tag value.
     */
    @JvmName("cmnlqvfrxdrvhlye")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The tag name.
     */
    @JvmName("hjtuyjsdjtpmtsxh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The tag value.
     */
    @JvmName("ffoptvyyhybicfda")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TagArgs = TagArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
