@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The cluster sku definition.
 * @property capacity The capacity value
 * @property name The name of the SKU.
 */
public data class ClusterSkuResponse(
    public val capacity: Double? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.ClusterSkuResponse): ClusterSkuResponse = ClusterSkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
