@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The top level Log Analytics cluster resource container.
 * @property associatedWorkspaces The list of Log Analytics workspaces associated with the cluster
 * @property billingType The cluster's billing type.
 * @property capacityReservationProperties Additional properties for capacity reservation
 * @property clusterId The ID associated with the cluster.
 * @property createdDate The cluster creation time
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identity of the resource.
 * @property isAvailabilityZonesEnabled Sets whether the cluster will support availability zones. This can be set as true only in regions where Azure Data Explorer support Availability Zones. This Property can not be modified after cluster creation. Default value is 'true' if region supports Availability Zones.
 * @property isDoubleEncryptionEnabled Configures whether cluster will use double encryption. This Property can not be modified after cluster creation. Default value is 'true'
 * @property keyVaultProperties The associated key properties.
 * @property lastModifiedDate The last time the cluster was updated.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the cluster.
 * @property sku The sku properties.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetClusterResult(
    public val associatedWorkspaces: List<AssociatedWorkspaceResponse>? = null,
    public val billingType: String? = null,
    public val capacityReservationProperties: CapacityReservationPropertiesResponse? = null,
    public val clusterId: String,
    public val createdDate: String,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val isAvailabilityZonesEnabled: Boolean? = null,
    public val isDoubleEncryptionEnabled: Boolean? = null,
    public val keyVaultProperties: KeyVaultPropertiesResponse? = null,
    public val lastModifiedDate: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val sku: ClusterSkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.GetClusterResult): GetClusterResult = GetClusterResult(
            associatedWorkspaces = javaType.associatedWorkspaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.AssociatedWorkspaceResponse.Companion.toKotlin(args0)
                })
            }),
            billingType = javaType.billingType().map({ args0 -> args0 }).orElse(null),
            capacityReservationProperties = javaType.capacityReservationProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.CapacityReservationPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            clusterId = javaType.clusterId(),
            createdDate = javaType.createdDate(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isAvailabilityZonesEnabled = javaType.isAvailabilityZonesEnabled().map({ args0 ->
                args0
            }).orElse(null),
            isDoubleEncryptionEnabled = javaType.isDoubleEncryptionEnabled().map({ args0 ->
                args0
            }).orElse(null),
            keyVaultProperties = javaType.keyVaultProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.KeyVaultPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastModifiedDate = javaType.lastModifiedDate(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.ClusterSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
