@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The top level data export resource container.
 * @property createdDate The latest data export rule modification time.
 * @property dataExportId The data export rule ID.
 * @property enable Active when enabled.
 * @property eventHubName Optional. Allows to define an Event Hub name. Not applicable when destination is Storage Account.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastModifiedDate Date and time when the export was last modified.
 * @property name The name of the resource
 * @property resourceId The destination resource ID. This can be copied from the Properties entry of the destination resource in Azure.
 * @property tableNames An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDataExportResult(
    public val createdDate: String? = null,
    public val dataExportId: String? = null,
    public val enable: Boolean? = null,
    public val eventHubName: String? = null,
    public val id: String,
    public val lastModifiedDate: String? = null,
    public val name: String,
    public val resourceId: String,
    public val tableNames: List<String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.GetDataExportResult): GetDataExportResult = GetDataExportResult(
            createdDate = javaType.createdDate().map({ args0 -> args0 }).orElse(null),
            dataExportId = javaType.dataExportId().map({ args0 -> args0 }).orElse(null),
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            eventHubName = javaType.eventHubName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastModifiedDate = javaType.lastModifiedDate().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            resourceId = javaType.resourceId(),
            tableNames = javaType.tableNames().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
