@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Linked storage accounts top level resource container.
 * @property dataSourceType Linked storage accounts type.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property storageAccountIds Linked storage accounts resources ids.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetLinkedStorageAccountResult(
    public val dataSourceType: String,
    public val id: String,
    public val name: String,
    public val storageAccountIds: List<String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.GetLinkedStorageAccountResult): GetLinkedStorageAccountResult = GetLinkedStorageAccountResult(
            dataSourceType = javaType.dataSourceType(),
            id = javaType.id(),
            name = javaType.name(),
            storageAccountIds = javaType.storageAccountIds().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
