@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An Log Analytics QueryPack definition.
 * @property id Azure resource Id
 * @property location Resource location
 * @property name Azure resource name
 * @property provisioningState Current state of this QueryPack: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
 * @property queryPackId The unique ID of your application. This field cannot be changed.
 * @property tags Resource tags
 * @property timeCreated Creation Date for the Log Analytics QueryPack, in ISO 8601 format.
 * @property timeModified Last modified date of the Log Analytics QueryPack, in ISO 8601 format.
 * @property type Azure resource type
 */
public data class GetQueryPackResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val queryPackId: String,
    public val tags: Map<String, String>? = null,
    public val timeCreated: String,
    public val timeModified: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.GetQueryPackResult): GetQueryPackResult = GetQueryPackResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            queryPackId = javaType.queryPackId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeCreated = javaType.timeCreated(),
            timeModified = javaType.timeModified(),
            type = javaType.type(),
        )
    }
}
