@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A Log Analytics QueryPack-Query definition.
 * @property author Object Id of user creating the query.
 * @property body Body of the query.
 * @property description Description of the query.
 * @property displayName Unique display name for your query within the Query Pack.
 * @property id Azure resource Id
 * @property name Azure resource name
 * @property properties Additional properties that can be set for the query.
 * @property related The related metadata items for the function.
 * @property systemData Read only system data
 * @property tags Tags associated with the query.
 * @property timeCreated Creation Date for the Log Analytics Query, in ISO 8601 format.
 * @property timeModified Last modified date of the Log Analytics Query, in ISO 8601 format.
 * @property type Azure resource type
 */
public data class GetQueryResult(
    public val author: String,
    public val body: String,
    public val description: String? = null,
    public val displayName: String,
    public val id: String,
    public val name: String,
    public val properties: Any,
    public val related: LogAnalyticsQueryPackQueryPropertiesResponseRelated? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, List<String>>? = null,
    public val timeCreated: String,
    public val timeModified: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.GetQueryResult): GetQueryResult = GetQueryResult(
            author = javaType.author(),
            body = javaType.body(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties(),
            related = javaType.related().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.LogAnalyticsQueryPackQueryPropertiesResponseRelated.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.operationalinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value.map({ args0 -> args0 })) }).toMap(),
            timeCreated = javaType.timeCreated(),
            timeModified = javaType.timeModified(),
            type = javaType.type(),
        )
    }
}
